/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.DestinationSchemaMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the data format when records are written to the destination. For more information, see <a
 * href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html">Configuring Application
 * Output</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DestinationSchema implements StructuredPojo, ToCopyableBuilder<DestinationSchema.Builder, DestinationSchema> {
    private final String recordFormatType;

    private DestinationSchema(BuilderImpl builder) {
        this.recordFormatType = builder.recordFormatType;
    }

    /**
     * <p>
     * Specifies the format of the records on the output stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordFormatType}
     * will return {@link RecordFormatType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #recordFormatTypeString}.
     * </p>
     * 
     * @return Specifies the format of the records on the output stream.
     * @see RecordFormatType
     */
    public RecordFormatType recordFormatType() {
        return RecordFormatType.fromValue(recordFormatType);
    }

    /**
     * <p>
     * Specifies the format of the records on the output stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordFormatType}
     * will return {@link RecordFormatType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #recordFormatTypeString}.
     * </p>
     * 
     * @return Specifies the format of the records on the output stream.
     * @see RecordFormatType
     */
    public String recordFormatTypeString() {
        return recordFormatType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recordFormatTypeString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationSchema)) {
            return false;
        }
        DestinationSchema other = (DestinationSchema) obj;
        return Objects.equals(recordFormatTypeString(), other.recordFormatTypeString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (recordFormatTypeString() != null) {
            sb.append("RecordFormatType: ").append(recordFormatTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecordFormatType":
            return Optional.of(clazz.cast(recordFormatTypeString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DestinationSchemaMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DestinationSchema> {
        /**
         * <p>
         * Specifies the format of the records on the output stream.
         * </p>
         * 
         * @param recordFormatType
         *        Specifies the format of the records on the output stream.
         * @see RecordFormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordFormatType
         */
        Builder recordFormatType(String recordFormatType);

        /**
         * <p>
         * Specifies the format of the records on the output stream.
         * </p>
         * 
         * @param recordFormatType
         *        Specifies the format of the records on the output stream.
         * @see RecordFormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordFormatType
         */
        Builder recordFormatType(RecordFormatType recordFormatType);
    }

    static final class BuilderImpl implements Builder {
        private String recordFormatType;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationSchema model) {
            recordFormatType(model.recordFormatType);
        }

        public final String getRecordFormatType() {
            return recordFormatType;
        }

        @Override
        public final Builder recordFormatType(String recordFormatType) {
            this.recordFormatType = recordFormatType;
            return this;
        }

        @Override
        public final Builder recordFormatType(RecordFormatType recordFormatType) {
            this.recordFormatType(recordFormatType.toString());
            return this;
        }

        public final void setRecordFormatType(String recordFormatType) {
            this.recordFormatType = recordFormatType;
        }

        @Override
        public DestinationSchema build() {
            return new DestinationSchema(this);
        }
    }
}
