/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class AddApplicationOutputRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<AddApplicationOutputRequest.Builder, AddApplicationOutputRequest> {
    private final String applicationName;

    private final Long currentApplicationVersionId;

    private final Output output;

    private AddApplicationOutputRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.output = builder.output;
    }

    /**
     * <p>
     * Name of the application to which you want to add the output configuration.
     * </p>
     * 
     * @return Name of the application to which you want to add the output configuration.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * Version of the application to which you want add the output configuration. You can use the
     * <a>DescribeApplication</a> operation to get the current application version. If the version specified is not the
     * current version, the <code>ConcurrentModificationException</code> is returned.
     * </p>
     * 
     * @return Version of the application to which you want add the output configuration. You can use the
     *         <a>DescribeApplication</a> operation to get the current application version. If the version specified is
     *         not the current version, the <code>ConcurrentModificationException</code> is returned.
     */
    public Long currentApplicationVersionId() {
        return currentApplicationVersionId;
    }

    /**
     * <p>
     * An array of objects, each describing one output configuration. In the output configuration, you specify the name
     * of an in-application stream, a destination (that is, an Amazon Kinesis stream or an Amazon Kinesis Firehose
     * delivery stream), and record the formation to use when writing to the destination.
     * </p>
     * 
     * @return An array of objects, each describing one output configuration. In the output configuration, you specify
     *         the name of an in-application stream, a destination (that is, an Amazon Kinesis stream or an Amazon
     *         Kinesis Firehose delivery stream), and record the formation to use when writing to the destination.
     */
    public Output output() {
        return output;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(currentApplicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(output());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationOutputRequest)) {
            return false;
        }
        AddApplicationOutputRequest other = (AddApplicationOutputRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(currentApplicationVersionId(), other.currentApplicationVersionId())
                && Objects.equals(output(), other.output());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (applicationName() != null) {
            sb.append("ApplicationName: ").append(applicationName()).append(",");
        }
        if (currentApplicationVersionId() != null) {
            sb.append("CurrentApplicationVersionId: ").append(currentApplicationVersionId()).append(",");
        }
        if (output() != null) {
            sb.append("Output: ").append(output()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.of(clazz.cast(applicationName()));
        case "CurrentApplicationVersionId":
            return Optional.of(clazz.cast(currentApplicationVersionId()));
        case "Output":
            return Optional.of(clazz.cast(output()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, AddApplicationOutputRequest> {
        /**
         * <p>
         * Name of the application to which you want to add the output configuration.
         * </p>
         * 
         * @param applicationName
         *        Name of the application to which you want to add the output configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * Version of the application to which you want add the output configuration. You can use the
         * <a>DescribeApplication</a> operation to get the current application version. If the version specified is not
         * the current version, the <code>ConcurrentModificationException</code> is returned.
         * </p>
         * 
         * @param currentApplicationVersionId
         *        Version of the application to which you want add the output configuration. You can use the
         *        <a>DescribeApplication</a> operation to get the current application version. If the version specified
         *        is not the current version, the <code>ConcurrentModificationException</code> is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentApplicationVersionId(Long currentApplicationVersionId);

        /**
         * <p>
         * An array of objects, each describing one output configuration. In the output configuration, you specify the
         * name of an in-application stream, a destination (that is, an Amazon Kinesis stream or an Amazon Kinesis
         * Firehose delivery stream), and record the formation to use when writing to the destination.
         * </p>
         * 
         * @param output
         *        An array of objects, each describing one output configuration. In the output configuration, you
         *        specify the name of an in-application stream, a destination (that is, an Amazon Kinesis stream or an
         *        Amazon Kinesis Firehose delivery stream), and record the formation to use when writing to the
         *        destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(Output output);

        /**
         * <p>
         * An array of objects, each describing one output configuration. In the output configuration, you specify the
         * name of an in-application stream, a destination (that is, an Amazon Kinesis stream or an Amazon Kinesis
         * Firehose delivery stream), and record the formation to use when writing to the destination.
         * </p>
         * This is a convenience that creates an instance of the {@link Output.Builder} avoiding the need to create one
         * manually via {@link Output#builder()}.
         *
         * When the {@link Consumer} completes, {@link Output.Builder#build()} is called immediately and its result is
         * passed to {@link #output(Output)}.
         * 
         * @param output
         *        a consumer that will call methods on {@link Output.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #output(Output)
         */
        default Builder output(Consumer<Output.Builder> output) {
            return output(Output.builder().apply(output).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String applicationName;

        private Long currentApplicationVersionId;

        private Output output;

        private BuilderImpl() {
        }

        private BuilderImpl(AddApplicationOutputRequest model) {
            applicationName(model.applicationName);
            currentApplicationVersionId(model.currentApplicationVersionId);
            output(model.output);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Long getCurrentApplicationVersionId() {
            return currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        public final Output.Builder getOutput() {
            return output != null ? output.toBuilder() : null;
        }

        @Override
        public final Builder output(Output output) {
            this.output = output;
            return this;
        }

        public final void setOutput(Output.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        @Override
        public AddApplicationOutputRequest build() {
            return new AddApplicationOutputRequest(this);
        }
    }
}
