/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class AddApplicationInputRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<AddApplicationInputRequest.Builder, AddApplicationInputRequest> {
    private final String applicationName;

    private final Long currentApplicationVersionId;

    private final Input input;

    private AddApplicationInputRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.input = builder.input;
    }

    /**
     * <p>
     * Name of your existing Amazon Kinesis Analytics application to which you want to add the streaming source.
     * </p>
     * 
     * @return Name of your existing Amazon Kinesis Analytics application to which you want to add the streaming source.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * Current version of your Amazon Kinesis Analytics application. You can use the <a>DescribeApplication</a>
     * operation to find the current application version.
     * </p>
     * 
     * @return Current version of your Amazon Kinesis Analytics application. You can use the <a>DescribeApplication</a>
     *         operation to find the current application version.
     */
    public Long currentApplicationVersionId() {
        return currentApplicationVersionId;
    }

    /**
     * <p>
     * The <a>Input</a> to add.
     * </p>
     * 
     * @return The <a>Input</a> to add.
     */
    public Input input() {
        return input;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(currentApplicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationInputRequest)) {
            return false;
        }
        AddApplicationInputRequest other = (AddApplicationInputRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(currentApplicationVersionId(), other.currentApplicationVersionId())
                && Objects.equals(input(), other.input());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (applicationName() != null) {
            sb.append("ApplicationName: ").append(applicationName()).append(",");
        }
        if (currentApplicationVersionId() != null) {
            sb.append("CurrentApplicationVersionId: ").append(currentApplicationVersionId()).append(",");
        }
        if (input() != null) {
            sb.append("Input: ").append(input()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.of(clazz.cast(applicationName()));
        case "CurrentApplicationVersionId":
            return Optional.of(clazz.cast(currentApplicationVersionId()));
        case "Input":
            return Optional.of(clazz.cast(input()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, AddApplicationInputRequest> {
        /**
         * <p>
         * Name of your existing Amazon Kinesis Analytics application to which you want to add the streaming source.
         * </p>
         * 
         * @param applicationName
         *        Name of your existing Amazon Kinesis Analytics application to which you want to add the streaming
         *        source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * Current version of your Amazon Kinesis Analytics application. You can use the <a>DescribeApplication</a>
         * operation to find the current application version.
         * </p>
         * 
         * @param currentApplicationVersionId
         *        Current version of your Amazon Kinesis Analytics application. You can use the
         *        <a>DescribeApplication</a> operation to find the current application version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentApplicationVersionId(Long currentApplicationVersionId);

        /**
         * <p>
         * The <a>Input</a> to add.
         * </p>
         * 
         * @param input
         *        The <a>Input</a> to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(Input input);

        /**
         * <p>
         * The <a>Input</a> to add.
         * </p>
         * This is a convenience that creates an instance of the {@link Input.Builder} avoiding the need to create one
         * manually via {@link Input#builder()}.
         *
         * When the {@link Consumer} completes, {@link Input.Builder#build()} is called immediately and its result is
         * passed to {@link #input(Input)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link Input.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(Input)
         */
        default Builder input(Consumer<Input.Builder> input) {
            return input(Input.builder().apply(input).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String applicationName;

        private Long currentApplicationVersionId;

        private Input input;

        private BuilderImpl() {
        }

        private BuilderImpl(AddApplicationInputRequest model) {
            applicationName(model.applicationName);
            currentApplicationVersionId(model.currentApplicationVersionId);
            input(model.input);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Long getCurrentApplicationVersionId() {
            return currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        public final Input.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        @Override
        public final Builder input(Input input) {
            this.input = input;
            return this;
        }

        public final void setInput(Input.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public AddApplicationInputRequest build() {
            return new AddApplicationInputRequest(this);
        }
    }
}
