/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for <code>ListStreams</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListStreamsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListStreamsRequest.Builder, ListStreamsRequest> {
    private final Integer limit;

    private final String exclusiveStartStreamName;

    private ListStreamsRequest(BuilderImpl builder) {
        this.limit = builder.limit;
        this.exclusiveStartStreamName = builder.exclusiveStartStreamName;
    }

    /**
     * <p>
     * The maximum number of streams to list.
     * </p>
     * 
     * @return The maximum number of streams to list.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The name of the stream to start the list with.
     * </p>
     * 
     * @return The name of the stream to start the list with.
     */
    public String exclusiveStartStreamName() {
        return exclusiveStartStreamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(exclusiveStartStreamName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamsRequest)) {
            return false;
        }
        ListStreamsRequest other = (ListStreamsRequest) obj;
        return Objects.equals(limit(), other.limit())
                && Objects.equals(exclusiveStartStreamName(), other.exclusiveStartStreamName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (limit() != null) {
            sb.append("Limit: ").append(limit()).append(",");
        }
        if (exclusiveStartStreamName() != null) {
            sb.append("ExclusiveStartStreamName: ").append(exclusiveStartStreamName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Limit":
            return Optional.of(clazz.cast(limit()));
        case "ExclusiveStartStreamName":
            return Optional.of(clazz.cast(exclusiveStartStreamName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListStreamsRequest> {
        /**
         * <p>
         * The maximum number of streams to list.
         * </p>
         * 
         * @param limit
         *        The maximum number of streams to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The name of the stream to start the list with.
         * </p>
         * 
         * @param exclusiveStartStreamName
         *        The name of the stream to start the list with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveStartStreamName(String exclusiveStartStreamName);
    }

    static final class BuilderImpl implements Builder {
        private Integer limit;

        private String exclusiveStartStreamName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamsRequest model) {
            limit(model.limit);
            exclusiveStartStreamName(model.exclusiveStartStreamName);
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getExclusiveStartStreamName() {
            return exclusiveStartStreamName;
        }

        @Override
        public final Builder exclusiveStartStreamName(String exclusiveStartStreamName) {
            this.exclusiveStartStreamName = exclusiveStartStreamName;
            return this;
        }

        public final void setExclusiveStartStreamName(String exclusiveStartStreamName) {
            this.exclusiveStartStreamName = exclusiveStartStreamName;
        }

        @Override
        public ListStreamsRequest build() {
            return new ListStreamsRequest(this);
        }
    }
}
