/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.ProcessorMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a data processor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Processor implements StructuredPojo, ToCopyableBuilder<Processor.Builder, Processor> {
    private final String type;

    private final List<ProcessorParameter> parameters;

    private Processor(BuilderImpl builder) {
        this.type = builder.type;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The type of processor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ProcessorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type of processor.
     * @see ProcessorType
     */
    public ProcessorType type() {
        return ProcessorType.fromValue(type);
    }

    /**
     * <p>
     * The type of processor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ProcessorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type of processor.
     * @see ProcessorType
     */
    public String typeString() {
        return type;
    }

    /**
     * <p>
     * The processor parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The processor parameters.
     */
    public List<ProcessorParameter> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeString());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Processor)) {
            return false;
        }
        Processor other = (Processor) obj;
        return Objects.equals(typeString(), other.typeString()) && Objects.equals(parameters(), other.parameters());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (typeString() != null) {
            sb.append("Type: ").append(typeString()).append(",");
        }
        if (parameters() != null) {
            sb.append("Parameters: ").append(parameters()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.of(clazz.cast(typeString()));
        case "Parameters":
            return Optional.of(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProcessorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Processor> {
        /**
         * <p>
         * The type of processor.
         * </p>
         * 
         * @param type
         *        The type of processor.
         * @see ProcessorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessorType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of processor.
         * </p>
         * 
         * @param type
         *        The type of processor.
         * @see ProcessorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessorType
         */
        Builder type(ProcessorType type);

        /**
         * <p>
         * The processor parameters.
         * </p>
         * 
         * @param parameters
         *        The processor parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<ProcessorParameter> parameters);

        /**
         * <p>
         * The processor parameters.
         * </p>
         * 
         * @param parameters
         *        The processor parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(ProcessorParameter... parameters);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private List<ProcessorParameter> parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(Processor model) {
            type(model.type);
            parameters(model.parameters);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ProcessorType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<ProcessorParameter.Builder> getParameters() {
            return parameters != null ? parameters.stream().map(ProcessorParameter::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder parameters(Collection<ProcessorParameter> parameters) {
            this.parameters = ProcessorParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(ProcessorParameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        public final void setParameters(Collection<ProcessorParameter.BuilderImpl> parameters) {
            this.parameters = ProcessorParameterListCopier.copyFromBuilder(parameters);
        }

        @Override
        public Processor build() {
            return new Processor(this);
        }
    }
}
