/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.KinesisStreamSourceDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a Kinesis stream used as the source for a Kinesis Firehose delivery stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class KinesisStreamSourceDescription implements StructuredPojo,
        ToCopyableBuilder<KinesisStreamSourceDescription.Builder, KinesisStreamSourceDescription> {
    private final String kinesisStreamARN;

    private final String roleARN;

    private final Instant deliveryStartTimestamp;

    private KinesisStreamSourceDescription(BuilderImpl builder) {
        this.kinesisStreamARN = builder.kinesisStreamARN;
        this.roleARN = builder.roleARN;
        this.deliveryStartTimestamp = builder.deliveryStartTimestamp;
    }

    /**
     * <p>
     * The ARN of the source Kinesis stream.
     * </p>
     * 
     * @return The ARN of the source Kinesis stream.
     */
    public String kinesisStreamARN() {
        return kinesisStreamARN;
    }

    /**
     * <p>
     * The ARN of the role used by the source Kinesis stream.
     * </p>
     * 
     * @return The ARN of the role used by the source Kinesis stream.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * Kinesis Firehose starts retrieving records from the Kinesis stream starting with this time stamp.
     * </p>
     * 
     * @return Kinesis Firehose starts retrieving records from the Kinesis stream starting with this time stamp.
     */
    public Instant deliveryStartTimestamp() {
        return deliveryStartTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamARN());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStartTimestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisStreamSourceDescription)) {
            return false;
        }
        KinesisStreamSourceDescription other = (KinesisStreamSourceDescription) obj;
        return Objects.equals(kinesisStreamARN(), other.kinesisStreamARN()) && Objects.equals(roleARN(), other.roleARN())
                && Objects.equals(deliveryStartTimestamp(), other.deliveryStartTimestamp());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (kinesisStreamARN() != null) {
            sb.append("KinesisStreamARN: ").append(kinesisStreamARN()).append(",");
        }
        if (roleARN() != null) {
            sb.append("RoleARN: ").append(roleARN()).append(",");
        }
        if (deliveryStartTimestamp() != null) {
            sb.append("DeliveryStartTimestamp: ").append(deliveryStartTimestamp()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KinesisStreamARN":
            return Optional.of(clazz.cast(kinesisStreamARN()));
        case "RoleARN":
            return Optional.of(clazz.cast(roleARN()));
        case "DeliveryStartTimestamp":
            return Optional.of(clazz.cast(deliveryStartTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KinesisStreamSourceDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, KinesisStreamSourceDescription> {
        /**
         * <p>
         * The ARN of the source Kinesis stream.
         * </p>
         * 
         * @param kinesisStreamARN
         *        The ARN of the source Kinesis stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamARN(String kinesisStreamARN);

        /**
         * <p>
         * The ARN of the role used by the source Kinesis stream.
         * </p>
         * 
         * @param roleARN
         *        The ARN of the role used by the source Kinesis stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * Kinesis Firehose starts retrieving records from the Kinesis stream starting with this time stamp.
         * </p>
         * 
         * @param deliveryStartTimestamp
         *        Kinesis Firehose starts retrieving records from the Kinesis stream starting with this time stamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStartTimestamp(Instant deliveryStartTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String kinesisStreamARN;

        private String roleARN;

        private Instant deliveryStartTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisStreamSourceDescription model) {
            kinesisStreamARN(model.kinesisStreamARN);
            roleARN(model.roleARN);
            deliveryStartTimestamp(model.deliveryStartTimestamp);
        }

        public final String getKinesisStreamARN() {
            return kinesisStreamARN;
        }

        @Override
        public final Builder kinesisStreamARN(String kinesisStreamARN) {
            this.kinesisStreamARN = kinesisStreamARN;
            return this;
        }

        public final void setKinesisStreamARN(String kinesisStreamARN) {
            this.kinesisStreamARN = kinesisStreamARN;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final Instant getDeliveryStartTimestamp() {
            return deliveryStartTimestamp;
        }

        @Override
        public final Builder deliveryStartTimestamp(Instant deliveryStartTimestamp) {
            this.deliveryStartTimestamp = deliveryStartTimestamp;
            return this;
        }

        public final void setDeliveryStartTimestamp(Instant deliveryStartTimestamp) {
            this.deliveryStartTimestamp = deliveryStartTimestamp;
        }

        @Override
        public KinesisStreamSourceDescription build() {
            return new KinesisStreamSourceDescription(this);
        }
    }
}
