/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.KinesisStreamSourceConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The stream and role ARNs for a Kinesis stream used as the source for a delivery stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class KinesisStreamSourceConfiguration implements StructuredPojo,
        ToCopyableBuilder<KinesisStreamSourceConfiguration.Builder, KinesisStreamSourceConfiguration> {
    private final String kinesisStreamARN;

    private final String roleARN;

    private KinesisStreamSourceConfiguration(BuilderImpl builder) {
        this.kinesisStreamARN = builder.kinesisStreamARN;
        this.roleARN = builder.roleARN;
    }

    /**
     * <p>
     * The ARN of the source Kinesis stream.
     * </p>
     * 
     * @return The ARN of the source Kinesis stream.
     */
    public String kinesisStreamARN() {
        return kinesisStreamARN;
    }

    /**
     * <p>
     * The ARN of the role that provides access to the source Kinesis stream.
     * </p>
     * 
     * @return The ARN of the role that provides access to the source Kinesis stream.
     */
    public String roleARN() {
        return roleARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamARN());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisStreamSourceConfiguration)) {
            return false;
        }
        KinesisStreamSourceConfiguration other = (KinesisStreamSourceConfiguration) obj;
        return Objects.equals(kinesisStreamARN(), other.kinesisStreamARN()) && Objects.equals(roleARN(), other.roleARN());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (kinesisStreamARN() != null) {
            sb.append("KinesisStreamARN: ").append(kinesisStreamARN()).append(",");
        }
        if (roleARN() != null) {
            sb.append("RoleARN: ").append(roleARN()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KinesisStreamARN":
            return Optional.of(clazz.cast(kinesisStreamARN()));
        case "RoleARN":
            return Optional.of(clazz.cast(roleARN()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KinesisStreamSourceConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, KinesisStreamSourceConfiguration> {
        /**
         * <p>
         * The ARN of the source Kinesis stream.
         * </p>
         * 
         * @param kinesisStreamARN
         *        The ARN of the source Kinesis stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamARN(String kinesisStreamARN);

        /**
         * <p>
         * The ARN of the role that provides access to the source Kinesis stream.
         * </p>
         * 
         * @param roleARN
         *        The ARN of the role that provides access to the source Kinesis stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);
    }

    static final class BuilderImpl implements Builder {
        private String kinesisStreamARN;

        private String roleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisStreamSourceConfiguration model) {
            kinesisStreamARN(model.kinesisStreamARN);
            roleARN(model.roleARN);
        }

        public final String getKinesisStreamARN() {
            return kinesisStreamARN;
        }

        @Override
        public final Builder kinesisStreamARN(String kinesisStreamARN) {
            this.kinesisStreamARN = kinesisStreamARN;
            return this;
        }

        public final void setKinesisStreamARN(String kinesisStreamARN) {
            this.kinesisStreamARN = kinesisStreamARN;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public KinesisStreamSourceConfiguration build() {
            return new KinesisStreamSourceConfiguration(this);
        }
    }
}
