/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.EncryptionConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the encryption for a destination in Amazon S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class EncryptionConfiguration implements StructuredPojo,
        ToCopyableBuilder<EncryptionConfiguration.Builder, EncryptionConfiguration> {
    private final String noEncryptionConfig;

    private final KMSEncryptionConfig kmsEncryptionConfig;

    private EncryptionConfiguration(BuilderImpl builder) {
        this.noEncryptionConfig = builder.noEncryptionConfig;
        this.kmsEncryptionConfig = builder.kmsEncryptionConfig;
    }

    /**
     * <p>
     * Specifically override existing encryption information to ensure that no encryption is used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #noEncryptionConfig} will return {@link NoEncryptionConfig#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #noEncryptionConfigString}.
     * </p>
     * 
     * @return Specifically override existing encryption information to ensure that no encryption is used.
     * @see NoEncryptionConfig
     */
    public NoEncryptionConfig noEncryptionConfig() {
        return NoEncryptionConfig.fromValue(noEncryptionConfig);
    }

    /**
     * <p>
     * Specifically override existing encryption information to ensure that no encryption is used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #noEncryptionConfig} will return {@link NoEncryptionConfig#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #noEncryptionConfigString}.
     * </p>
     * 
     * @return Specifically override existing encryption information to ensure that no encryption is used.
     * @see NoEncryptionConfig
     */
    public String noEncryptionConfigString() {
        return noEncryptionConfig;
    }

    /**
     * <p>
     * The encryption key.
     * </p>
     * 
     * @return The encryption key.
     */
    public KMSEncryptionConfig kmsEncryptionConfig() {
        return kmsEncryptionConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(noEncryptionConfigString());
        hashCode = 31 * hashCode + Objects.hashCode(kmsEncryptionConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionConfiguration)) {
            return false;
        }
        EncryptionConfiguration other = (EncryptionConfiguration) obj;
        return Objects.equals(noEncryptionConfigString(), other.noEncryptionConfigString())
                && Objects.equals(kmsEncryptionConfig(), other.kmsEncryptionConfig());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (noEncryptionConfigString() != null) {
            sb.append("NoEncryptionConfig: ").append(noEncryptionConfigString()).append(",");
        }
        if (kmsEncryptionConfig() != null) {
            sb.append("KMSEncryptionConfig: ").append(kmsEncryptionConfig()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NoEncryptionConfig":
            return Optional.of(clazz.cast(noEncryptionConfigString()));
        case "KMSEncryptionConfig":
            return Optional.of(clazz.cast(kmsEncryptionConfig()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EncryptionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, EncryptionConfiguration> {
        /**
         * <p>
         * Specifically override existing encryption information to ensure that no encryption is used.
         * </p>
         * 
         * @param noEncryptionConfig
         *        Specifically override existing encryption information to ensure that no encryption is used.
         * @see NoEncryptionConfig
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NoEncryptionConfig
         */
        Builder noEncryptionConfig(String noEncryptionConfig);

        /**
         * <p>
         * Specifically override existing encryption information to ensure that no encryption is used.
         * </p>
         * 
         * @param noEncryptionConfig
         *        Specifically override existing encryption information to ensure that no encryption is used.
         * @see NoEncryptionConfig
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NoEncryptionConfig
         */
        Builder noEncryptionConfig(NoEncryptionConfig noEncryptionConfig);

        /**
         * <p>
         * The encryption key.
         * </p>
         * 
         * @param kmsEncryptionConfig
         *        The encryption key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsEncryptionConfig(KMSEncryptionConfig kmsEncryptionConfig);

        /**
         * <p>
         * The encryption key.
         * </p>
         * This is a convenience that creates an instance of the {@link KMSEncryptionConfig.Builder} avoiding the need
         * to create one manually via {@link KMSEncryptionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link KMSEncryptionConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #kmsEncryptionConfig(KMSEncryptionConfig)}.
         * 
         * @param kmsEncryptionConfig
         *        a consumer that will call methods on {@link KMSEncryptionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kmsEncryptionConfig(KMSEncryptionConfig)
         */
        default Builder kmsEncryptionConfig(Consumer<KMSEncryptionConfig.Builder> kmsEncryptionConfig) {
            return kmsEncryptionConfig(KMSEncryptionConfig.builder().apply(kmsEncryptionConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String noEncryptionConfig;

        private KMSEncryptionConfig kmsEncryptionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionConfiguration model) {
            noEncryptionConfig(model.noEncryptionConfig);
            kmsEncryptionConfig(model.kmsEncryptionConfig);
        }

        public final String getNoEncryptionConfig() {
            return noEncryptionConfig;
        }

        @Override
        public final Builder noEncryptionConfig(String noEncryptionConfig) {
            this.noEncryptionConfig = noEncryptionConfig;
            return this;
        }

        @Override
        public final Builder noEncryptionConfig(NoEncryptionConfig noEncryptionConfig) {
            this.noEncryptionConfig(noEncryptionConfig.toString());
            return this;
        }

        public final void setNoEncryptionConfig(String noEncryptionConfig) {
            this.noEncryptionConfig = noEncryptionConfig;
        }

        public final KMSEncryptionConfig.Builder getKMSEncryptionConfig() {
            return kmsEncryptionConfig != null ? kmsEncryptionConfig.toBuilder() : null;
        }

        @Override
        public final Builder kmsEncryptionConfig(KMSEncryptionConfig kmsEncryptionConfig) {
            this.kmsEncryptionConfig = kmsEncryptionConfig;
            return this;
        }

        public final void setKMSEncryptionConfig(KMSEncryptionConfig.BuilderImpl kmsEncryptionConfig) {
            this.kmsEncryptionConfig = kmsEncryptionConfig != null ? kmsEncryptionConfig.build() : null;
        }

        @Override
        public EncryptionConfiguration build() {
            return new EncryptionConfiguration(this);
        }
    }
}
