/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.BufferingHintsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes hints for the buffering to perform before delivering data to the destination. Please note that these
 * options are treated as hints, and therefore Kinesis Firehose may choose to use different values when it is optimal.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BufferingHints implements StructuredPojo, ToCopyableBuilder<BufferingHints.Builder, BufferingHints> {
    private final Integer sizeInMBs;

    private final Integer intervalInSeconds;

    private BufferingHints(BuilderImpl builder) {
        this.sizeInMBs = builder.sizeInMBs;
        this.intervalInSeconds = builder.intervalInSeconds;
    }

    /**
     * <p>
     * Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The default value is
     * 5.
     * </p>
     * <p>
     * We recommend setting this parameter to a value greater than the amount of data you typically ingest into the
     * delivery stream in 10 seconds. For example, if you typically ingest data at 1 MB/sec, the value should be 10 MB
     * or higher.
     * </p>
     * 
     * @return Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The default
     *         value is 5.</p>
     *         <p>
     *         We recommend setting this parameter to a value greater than the amount of data you typically ingest into
     *         the delivery stream in 10 seconds. For example, if you typically ingest data at 1 MB/sec, the value
     *         should be 10 MB or higher.
     */
    public Integer sizeInMBs() {
        return sizeInMBs;
    }

    /**
     * <p>
     * Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination. The
     * default value is 300.
     * </p>
     * 
     * @return Buffer incoming data for the specified period of time, in seconds, before delivering it to the
     *         destination. The default value is 300.
     */
    public Integer intervalInSeconds() {
        return intervalInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sizeInMBs());
        hashCode = 31 * hashCode + Objects.hashCode(intervalInSeconds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BufferingHints)) {
            return false;
        }
        BufferingHints other = (BufferingHints) obj;
        return Objects.equals(sizeInMBs(), other.sizeInMBs()) && Objects.equals(intervalInSeconds(), other.intervalInSeconds());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (sizeInMBs() != null) {
            sb.append("SizeInMBs: ").append(sizeInMBs()).append(",");
        }
        if (intervalInSeconds() != null) {
            sb.append("IntervalInSeconds: ").append(intervalInSeconds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SizeInMBs":
            return Optional.of(clazz.cast(sizeInMBs()));
        case "IntervalInSeconds":
            return Optional.of(clazz.cast(intervalInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BufferingHintsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, BufferingHints> {
        /**
         * <p>
         * Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The default
         * value is 5.
         * </p>
         * <p>
         * We recommend setting this parameter to a value greater than the amount of data you typically ingest into the
         * delivery stream in 10 seconds. For example, if you typically ingest data at 1 MB/sec, the value should be 10
         * MB or higher.
         * </p>
         * 
         * @param sizeInMBs
         *        Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The
         *        default value is 5.</p>
         *        <p>
         *        We recommend setting this parameter to a value greater than the amount of data you typically ingest
         *        into the delivery stream in 10 seconds. For example, if you typically ingest data at 1 MB/sec, the
         *        value should be 10 MB or higher.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInMBs(Integer sizeInMBs);

        /**
         * <p>
         * Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination.
         * The default value is 300.
         * </p>
         * 
         * @param intervalInSeconds
         *        Buffer incoming data for the specified period of time, in seconds, before delivering it to the
         *        destination. The default value is 300.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intervalInSeconds(Integer intervalInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer sizeInMBs;

        private Integer intervalInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(BufferingHints model) {
            sizeInMBs(model.sizeInMBs);
            intervalInSeconds(model.intervalInSeconds);
        }

        public final Integer getSizeInMBs() {
            return sizeInMBs;
        }

        @Override
        public final Builder sizeInMBs(Integer sizeInMBs) {
            this.sizeInMBs = sizeInMBs;
            return this;
        }

        public final void setSizeInMBs(Integer sizeInMBs) {
            this.sizeInMBs = sizeInMBs;
        }

        public final Integer getIntervalInSeconds() {
            return intervalInSeconds;
        }

        @Override
        public final Builder intervalInSeconds(Integer intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
            return this;
        }

        public final void setIntervalInSeconds(Integer intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
        }

        @Override
        public BufferingHints build() {
            return new BufferingHints(this);
        }
    }
}
