/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.DestinationSchema;

@SdkInternalApi
public class DestinationSchemaMarshaller {
    private static final MarshallingInfo<String> RECORDFORMATTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordFormatType").build();
    private static final DestinationSchemaMarshaller INSTANCE = new DestinationSchemaMarshaller();

    public static DestinationSchemaMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DestinationSchema destinationSchema, ProtocolMarshaller protocolMarshaller) {
        if (destinationSchema == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)destinationSchema.recordFormatTypeString(), RECORDFORMATTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

