/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceDescription;
import software.amazon.awssdk.services.kinesisanalytics.model.SourceSchema;
import software.amazon.awssdk.services.kinesisanalytics.transform.ReferenceDataSourceDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReferenceDataSourceDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, ReferenceDataSourceDescription> {
    private final String referenceId;
    private final String tableName;
    private final S3ReferenceDataSourceDescription s3ReferenceDataSourceDescription;
    private final SourceSchema referenceSchema;

    private ReferenceDataSourceDescription(BuilderImpl builder) {
        this.referenceId = builder.referenceId;
        this.tableName = builder.tableName;
        this.s3ReferenceDataSourceDescription = builder.s3ReferenceDataSourceDescription;
        this.referenceSchema = builder.referenceSchema;
    }

    public String referenceId() {
        return this.referenceId;
    }

    public String tableName() {
        return this.tableName;
    }

    public S3ReferenceDataSourceDescription s3ReferenceDataSourceDescription() {
        return this.s3ReferenceDataSourceDescription;
    }

    public SourceSchema referenceSchema() {
        return this.referenceSchema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.referenceId() == null ? 0 : this.referenceId().hashCode());
        hashCode = 31 * hashCode + (this.tableName() == null ? 0 : this.tableName().hashCode());
        hashCode = 31 * hashCode + (this.s3ReferenceDataSourceDescription() == null ? 0 : this.s3ReferenceDataSourceDescription().hashCode());
        hashCode = 31 * hashCode + (this.referenceSchema() == null ? 0 : this.referenceSchema().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceDataSourceDescription)) {
            return false;
        }
        ReferenceDataSourceDescription other = (ReferenceDataSourceDescription)obj;
        if (other.referenceId() == null ^ this.referenceId() == null) {
            return false;
        }
        if (other.referenceId() != null && !other.referenceId().equals(this.referenceId())) {
            return false;
        }
        if (other.tableName() == null ^ this.tableName() == null) {
            return false;
        }
        if (other.tableName() != null && !other.tableName().equals(this.tableName())) {
            return false;
        }
        if (other.s3ReferenceDataSourceDescription() == null ^ this.s3ReferenceDataSourceDescription() == null) {
            return false;
        }
        if (other.s3ReferenceDataSourceDescription() != null && !other.s3ReferenceDataSourceDescription().equals(this.s3ReferenceDataSourceDescription())) {
            return false;
        }
        if (other.referenceSchema() == null ^ this.referenceSchema() == null) {
            return false;
        }
        return other.referenceSchema() == null || other.referenceSchema().equals(this.referenceSchema());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.referenceId() != null) {
            sb.append("ReferenceId: ").append(this.referenceId()).append(",");
        }
        if (this.tableName() != null) {
            sb.append("TableName: ").append(this.tableName()).append(",");
        }
        if (this.s3ReferenceDataSourceDescription() != null) {
            sb.append("S3ReferenceDataSourceDescription: ").append(this.s3ReferenceDataSourceDescription()).append(",");
        }
        if (this.referenceSchema() != null) {
            sb.append("ReferenceSchema: ").append(this.referenceSchema()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReferenceId": {
                return Optional.of(clazz.cast(this.referenceId()));
            }
            case "TableName": {
                return Optional.of(clazz.cast(this.tableName()));
            }
            case "S3ReferenceDataSourceDescription": {
                return Optional.of(clazz.cast(this.s3ReferenceDataSourceDescription()));
            }
            case "ReferenceSchema": {
                return Optional.of(clazz.cast(this.referenceSchema()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReferenceDataSourceDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String referenceId;
        private String tableName;
        private S3ReferenceDataSourceDescription s3ReferenceDataSourceDescription;
        private SourceSchema referenceSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceDataSourceDescription model) {
            this.referenceId(model.referenceId);
            this.tableName(model.tableName);
            this.s3ReferenceDataSourceDescription(model.s3ReferenceDataSourceDescription);
            this.referenceSchema(model.referenceSchema);
        }

        public final String getReferenceId() {
            return this.referenceId;
        }

        @Override
        public final Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final S3ReferenceDataSourceDescription.Builder getS3ReferenceDataSourceDescription() {
            return this.s3ReferenceDataSourceDescription != null ? this.s3ReferenceDataSourceDescription.toBuilder() : null;
        }

        @Override
        public final Builder s3ReferenceDataSourceDescription(S3ReferenceDataSourceDescription s3ReferenceDataSourceDescription) {
            this.s3ReferenceDataSourceDescription = s3ReferenceDataSourceDescription;
            return this;
        }

        public final void setS3ReferenceDataSourceDescription(S3ReferenceDataSourceDescription.BuilderImpl s3ReferenceDataSourceDescription) {
            this.s3ReferenceDataSourceDescription = s3ReferenceDataSourceDescription != null ? s3ReferenceDataSourceDescription.build() : null;
        }

        public final SourceSchema.Builder getReferenceSchema() {
            return this.referenceSchema != null ? this.referenceSchema.toBuilder() : null;
        }

        @Override
        public final Builder referenceSchema(SourceSchema referenceSchema) {
            this.referenceSchema = referenceSchema;
            return this;
        }

        public final void setReferenceSchema(SourceSchema.BuilderImpl referenceSchema) {
            this.referenceSchema = referenceSchema != null ? referenceSchema.build() : null;
        }

        public ReferenceDataSourceDescription build() {
            return new ReferenceDataSourceDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReferenceDataSourceDescription> {
        public Builder referenceId(String var1);

        public Builder tableName(String var1);

        public Builder s3ReferenceDataSourceDescription(S3ReferenceDataSourceDescription var1);

        public Builder referenceSchema(SourceSchema var1);
    }
}

