/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOption;
import software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionsCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.Input;
import software.amazon.awssdk.services.kinesisanalytics.model.InputsCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.Output;
import software.amazon.awssdk.services.kinesisanalytics.model.OutputsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateApplicationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateApplicationRequest> {
    private final String applicationName;
    private final String applicationDescription;
    private final List<Input> inputs;
    private final List<Output> outputs;
    private final List<CloudWatchLoggingOption> cloudWatchLoggingOptions;
    private final String applicationCode;

    private CreateApplicationRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.applicationDescription = builder.applicationDescription;
        this.inputs = builder.inputs;
        this.outputs = builder.outputs;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.applicationCode = builder.applicationCode;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String applicationDescription() {
        return this.applicationDescription;
    }

    public List<Input> inputs() {
        return this.inputs;
    }

    public List<Output> outputs() {
        return this.outputs;
    }

    public List<CloudWatchLoggingOption> cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public String applicationCode() {
        return this.applicationCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.applicationDescription() == null ? 0 : this.applicationDescription().hashCode());
        hashCode = 31 * hashCode + (this.inputs() == null ? 0 : this.inputs().hashCode());
        hashCode = 31 * hashCode + (this.outputs() == null ? 0 : this.outputs().hashCode());
        hashCode = 31 * hashCode + (this.cloudWatchLoggingOptions() == null ? 0 : this.cloudWatchLoggingOptions().hashCode());
        hashCode = 31 * hashCode + (this.applicationCode() == null ? 0 : this.applicationCode().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.applicationDescription() == null ^ this.applicationDescription() == null) {
            return false;
        }
        if (other.applicationDescription() != null && !other.applicationDescription().equals(this.applicationDescription())) {
            return false;
        }
        if (other.inputs() == null ^ this.inputs() == null) {
            return false;
        }
        if (other.inputs() != null && !other.inputs().equals(this.inputs())) {
            return false;
        }
        if (other.outputs() == null ^ this.outputs() == null) {
            return false;
        }
        if (other.outputs() != null && !other.outputs().equals(this.outputs())) {
            return false;
        }
        if (other.cloudWatchLoggingOptions() == null ^ this.cloudWatchLoggingOptions() == null) {
            return false;
        }
        if (other.cloudWatchLoggingOptions() != null && !other.cloudWatchLoggingOptions().equals(this.cloudWatchLoggingOptions())) {
            return false;
        }
        if (other.applicationCode() == null ^ this.applicationCode() == null) {
            return false;
        }
        return other.applicationCode() == null || other.applicationCode().equals(this.applicationCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.applicationDescription() != null) {
            sb.append("ApplicationDescription: ").append(this.applicationDescription()).append(",");
        }
        if (this.inputs() != null) {
            sb.append("Inputs: ").append(this.inputs()).append(",");
        }
        if (this.outputs() != null) {
            sb.append("Outputs: ").append(this.outputs()).append(",");
        }
        if (this.cloudWatchLoggingOptions() != null) {
            sb.append("CloudWatchLoggingOptions: ").append(this.cloudWatchLoggingOptions()).append(",");
        }
        if (this.applicationCode() != null) {
            sb.append("ApplicationCode: ").append(this.applicationCode()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "ApplicationDescription": {
                return Optional.of(clazz.cast(this.applicationDescription()));
            }
            case "Inputs": {
                return Optional.of(clazz.cast(this.inputs()));
            }
            case "Outputs": {
                return Optional.of(clazz.cast(this.outputs()));
            }
            case "CloudWatchLoggingOptions": {
                return Optional.of(clazz.cast(this.cloudWatchLoggingOptions()));
            }
            case "ApplicationCode": {
                return Optional.of(clazz.cast(this.applicationCode()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String applicationDescription;
        private List<Input> inputs;
        private List<Output> outputs;
        private List<CloudWatchLoggingOption> cloudWatchLoggingOptions;
        private String applicationCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationRequest model) {
            this.applicationName(model.applicationName);
            this.applicationDescription(model.applicationDescription);
            this.inputs(model.inputs);
            this.outputs(model.outputs);
            this.cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            this.applicationCode(model.applicationCode);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getApplicationDescription() {
            return this.applicationDescription;
        }

        @Override
        public final Builder applicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
            return this;
        }

        public final void setApplicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
        }

        public final Collection<Input.Builder> getInputs() {
            return this.inputs != null ? (Collection)this.inputs.stream().map(Input::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputs(Collection<Input> inputs) {
            this.inputs = InputsCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Input ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        public final void setInputs(Collection<Input.BuilderImpl> inputs) {
            this.inputs = InputsCopier.copyFromBuilder(inputs);
        }

        public final Collection<Output.Builder> getOutputs() {
            return this.outputs != null ? (Collection)this.outputs.stream().map(Output::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = OutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Output ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        public final void setOutputs(Collection<Output.BuilderImpl> outputs) {
            this.outputs = OutputsCopier.copyFromBuilder(outputs);
        }

        public final Collection<CloudWatchLoggingOption.Builder> getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions != null ? (Collection)this.cloudWatchLoggingOptions.stream().map(CloudWatchLoggingOption::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(Collection<CloudWatchLoggingOption> cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = CloudWatchLoggingOptionsCopier.copy(cloudWatchLoggingOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOption ... cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions(Arrays.asList(cloudWatchLoggingOptions));
            return this;
        }

        public final void setCloudWatchLoggingOptions(Collection<CloudWatchLoggingOption.BuilderImpl> cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = CloudWatchLoggingOptionsCopier.copyFromBuilder(cloudWatchLoggingOptions);
        }

        public final String getApplicationCode() {
            return this.applicationCode;
        }

        @Override
        public final Builder applicationCode(String applicationCode) {
            this.applicationCode = applicationCode;
            return this;
        }

        public final void setApplicationCode(String applicationCode) {
            this.applicationCode = applicationCode;
        }

        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateApplicationRequest> {
        public Builder applicationName(String var1);

        public Builder applicationDescription(String var1);

        public Builder inputs(Collection<Input> var1);

        public Builder inputs(Input ... var1);

        public Builder outputs(Collection<Output> var1);

        public Builder outputs(Output ... var1);

        public Builder cloudWatchLoggingOptions(Collection<CloudWatchLoggingOption> var1);

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOption ... var1);

        public Builder applicationCode(String var1);
    }
}

