/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionUpdate;
import software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionUpdatesCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.InputUpdate;
import software.amazon.awssdk.services.kinesisanalytics.model.InputUpdatesCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.OutputUpdate;
import software.amazon.awssdk.services.kinesisanalytics.model.OutputUpdatesCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceUpdate;
import software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceUpdatesCopier;
import software.amazon.awssdk.services.kinesisanalytics.transform.ApplicationUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ApplicationUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, ApplicationUpdate> {
    private final List<InputUpdate> inputUpdates;
    private final String applicationCodeUpdate;
    private final List<OutputUpdate> outputUpdates;
    private final List<ReferenceDataSourceUpdate> referenceDataSourceUpdates;
    private final List<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates;

    private ApplicationUpdate(BuilderImpl builder) {
        this.inputUpdates = builder.inputUpdates;
        this.applicationCodeUpdate = builder.applicationCodeUpdate;
        this.outputUpdates = builder.outputUpdates;
        this.referenceDataSourceUpdates = builder.referenceDataSourceUpdates;
        this.cloudWatchLoggingOptionUpdates = builder.cloudWatchLoggingOptionUpdates;
    }

    public List<InputUpdate> inputUpdates() {
        return this.inputUpdates;
    }

    public String applicationCodeUpdate() {
        return this.applicationCodeUpdate;
    }

    public List<OutputUpdate> outputUpdates() {
        return this.outputUpdates;
    }

    public List<ReferenceDataSourceUpdate> referenceDataSourceUpdates() {
        return this.referenceDataSourceUpdates;
    }

    public List<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates() {
        return this.cloudWatchLoggingOptionUpdates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.inputUpdates() == null ? 0 : this.inputUpdates().hashCode());
        hashCode = 31 * hashCode + (this.applicationCodeUpdate() == null ? 0 : this.applicationCodeUpdate().hashCode());
        hashCode = 31 * hashCode + (this.outputUpdates() == null ? 0 : this.outputUpdates().hashCode());
        hashCode = 31 * hashCode + (this.referenceDataSourceUpdates() == null ? 0 : this.referenceDataSourceUpdates().hashCode());
        hashCode = 31 * hashCode + (this.cloudWatchLoggingOptionUpdates() == null ? 0 : this.cloudWatchLoggingOptionUpdates().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationUpdate)) {
            return false;
        }
        ApplicationUpdate other = (ApplicationUpdate)obj;
        if (other.inputUpdates() == null ^ this.inputUpdates() == null) {
            return false;
        }
        if (other.inputUpdates() != null && !other.inputUpdates().equals(this.inputUpdates())) {
            return false;
        }
        if (other.applicationCodeUpdate() == null ^ this.applicationCodeUpdate() == null) {
            return false;
        }
        if (other.applicationCodeUpdate() != null && !other.applicationCodeUpdate().equals(this.applicationCodeUpdate())) {
            return false;
        }
        if (other.outputUpdates() == null ^ this.outputUpdates() == null) {
            return false;
        }
        if (other.outputUpdates() != null && !other.outputUpdates().equals(this.outputUpdates())) {
            return false;
        }
        if (other.referenceDataSourceUpdates() == null ^ this.referenceDataSourceUpdates() == null) {
            return false;
        }
        if (other.referenceDataSourceUpdates() != null && !other.referenceDataSourceUpdates().equals(this.referenceDataSourceUpdates())) {
            return false;
        }
        if (other.cloudWatchLoggingOptionUpdates() == null ^ this.cloudWatchLoggingOptionUpdates() == null) {
            return false;
        }
        return other.cloudWatchLoggingOptionUpdates() == null || other.cloudWatchLoggingOptionUpdates().equals(this.cloudWatchLoggingOptionUpdates());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.inputUpdates() != null) {
            sb.append("InputUpdates: ").append(this.inputUpdates()).append(",");
        }
        if (this.applicationCodeUpdate() != null) {
            sb.append("ApplicationCodeUpdate: ").append(this.applicationCodeUpdate()).append(",");
        }
        if (this.outputUpdates() != null) {
            sb.append("OutputUpdates: ").append(this.outputUpdates()).append(",");
        }
        if (this.referenceDataSourceUpdates() != null) {
            sb.append("ReferenceDataSourceUpdates: ").append(this.referenceDataSourceUpdates()).append(",");
        }
        if (this.cloudWatchLoggingOptionUpdates() != null) {
            sb.append("CloudWatchLoggingOptionUpdates: ").append(this.cloudWatchLoggingOptionUpdates()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputUpdates": {
                return Optional.of(clazz.cast(this.inputUpdates()));
            }
            case "ApplicationCodeUpdate": {
                return Optional.of(clazz.cast(this.applicationCodeUpdate()));
            }
            case "OutputUpdates": {
                return Optional.of(clazz.cast(this.outputUpdates()));
            }
            case "ReferenceDataSourceUpdates": {
                return Optional.of(clazz.cast(this.referenceDataSourceUpdates()));
            }
            case "CloudWatchLoggingOptionUpdates": {
                return Optional.of(clazz.cast(this.cloudWatchLoggingOptionUpdates()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<InputUpdate> inputUpdates;
        private String applicationCodeUpdate;
        private List<OutputUpdate> outputUpdates;
        private List<ReferenceDataSourceUpdate> referenceDataSourceUpdates;
        private List<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationUpdate model) {
            this.inputUpdates(model.inputUpdates);
            this.applicationCodeUpdate(model.applicationCodeUpdate);
            this.outputUpdates(model.outputUpdates);
            this.referenceDataSourceUpdates(model.referenceDataSourceUpdates);
            this.cloudWatchLoggingOptionUpdates(model.cloudWatchLoggingOptionUpdates);
        }

        public final Collection<InputUpdate.Builder> getInputUpdates() {
            return this.inputUpdates != null ? (Collection)this.inputUpdates.stream().map(InputUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputUpdates(Collection<InputUpdate> inputUpdates) {
            this.inputUpdates = InputUpdatesCopier.copy(inputUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputUpdates(InputUpdate ... inputUpdates) {
            this.inputUpdates(Arrays.asList(inputUpdates));
            return this;
        }

        public final void setInputUpdates(Collection<InputUpdate.BuilderImpl> inputUpdates) {
            this.inputUpdates = InputUpdatesCopier.copyFromBuilder(inputUpdates);
        }

        public final String getApplicationCodeUpdate() {
            return this.applicationCodeUpdate;
        }

        @Override
        public final Builder applicationCodeUpdate(String applicationCodeUpdate) {
            this.applicationCodeUpdate = applicationCodeUpdate;
            return this;
        }

        public final void setApplicationCodeUpdate(String applicationCodeUpdate) {
            this.applicationCodeUpdate = applicationCodeUpdate;
        }

        public final Collection<OutputUpdate.Builder> getOutputUpdates() {
            return this.outputUpdates != null ? (Collection)this.outputUpdates.stream().map(OutputUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputUpdates(Collection<OutputUpdate> outputUpdates) {
            this.outputUpdates = OutputUpdatesCopier.copy(outputUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputUpdates(OutputUpdate ... outputUpdates) {
            this.outputUpdates(Arrays.asList(outputUpdates));
            return this;
        }

        public final void setOutputUpdates(Collection<OutputUpdate.BuilderImpl> outputUpdates) {
            this.outputUpdates = OutputUpdatesCopier.copyFromBuilder(outputUpdates);
        }

        public final Collection<ReferenceDataSourceUpdate.Builder> getReferenceDataSourceUpdates() {
            return this.referenceDataSourceUpdates != null ? (Collection)this.referenceDataSourceUpdates.stream().map(ReferenceDataSourceUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder referenceDataSourceUpdates(Collection<ReferenceDataSourceUpdate> referenceDataSourceUpdates) {
            this.referenceDataSourceUpdates = ReferenceDataSourceUpdatesCopier.copy(referenceDataSourceUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceDataSourceUpdates(ReferenceDataSourceUpdate ... referenceDataSourceUpdates) {
            this.referenceDataSourceUpdates(Arrays.asList(referenceDataSourceUpdates));
            return this;
        }

        public final void setReferenceDataSourceUpdates(Collection<ReferenceDataSourceUpdate.BuilderImpl> referenceDataSourceUpdates) {
            this.referenceDataSourceUpdates = ReferenceDataSourceUpdatesCopier.copyFromBuilder(referenceDataSourceUpdates);
        }

        public final Collection<CloudWatchLoggingOptionUpdate.Builder> getCloudWatchLoggingOptionUpdates() {
            return this.cloudWatchLoggingOptionUpdates != null ? (Collection)this.cloudWatchLoggingOptionUpdates.stream().map(CloudWatchLoggingOptionUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptionUpdates(Collection<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates) {
            this.cloudWatchLoggingOptionUpdates = CloudWatchLoggingOptionUpdatesCopier.copy(cloudWatchLoggingOptionUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptionUpdates(CloudWatchLoggingOptionUpdate ... cloudWatchLoggingOptionUpdates) {
            this.cloudWatchLoggingOptionUpdates(Arrays.asList(cloudWatchLoggingOptionUpdates));
            return this;
        }

        public final void setCloudWatchLoggingOptionUpdates(Collection<CloudWatchLoggingOptionUpdate.BuilderImpl> cloudWatchLoggingOptionUpdates) {
            this.cloudWatchLoggingOptionUpdates = CloudWatchLoggingOptionUpdatesCopier.copyFromBuilder(cloudWatchLoggingOptionUpdates);
        }

        public ApplicationUpdate build() {
            return new ApplicationUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ApplicationUpdate> {
        public Builder inputUpdates(Collection<InputUpdate> var1);

        public Builder inputUpdates(InputUpdate ... var1);

        public Builder applicationCodeUpdate(String var1);

        public Builder outputUpdates(Collection<OutputUpdate> var1);

        public Builder outputUpdates(OutputUpdate ... var1);

        public Builder referenceDataSourceUpdates(Collection<ReferenceDataSourceUpdate> var1);

        public Builder referenceDataSourceUpdates(ReferenceDataSourceUpdate ... var1);

        public Builder cloudWatchLoggingOptionUpdates(Collection<CloudWatchLoggingOptionUpdate> var1);

        public Builder cloudWatchLoggingOptionUpdates(CloudWatchLoggingOptionUpdate ... var1);
    }
}

