/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateShardCountResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, UpdateShardCountResponse> {
    private final String streamName;
    private final Integer currentShardCount;
    private final Integer targetShardCount;

    private UpdateShardCountResponse(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.currentShardCount = builder.currentShardCount;
        this.targetShardCount = builder.targetShardCount;
    }

    public String streamName() {
        return this.streamName;
    }

    public Integer currentShardCount() {
        return this.currentShardCount;
    }

    public Integer targetShardCount() {
        return this.targetShardCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.streamName() == null ? 0 : this.streamName().hashCode());
        hashCode = 31 * hashCode + (this.currentShardCount() == null ? 0 : this.currentShardCount().hashCode());
        hashCode = 31 * hashCode + (this.targetShardCount() == null ? 0 : this.targetShardCount().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateShardCountResponse)) {
            return false;
        }
        UpdateShardCountResponse other = (UpdateShardCountResponse)((Object)obj);
        if (other.streamName() == null ^ this.streamName() == null) {
            return false;
        }
        if (other.streamName() != null && !other.streamName().equals(this.streamName())) {
            return false;
        }
        if (other.currentShardCount() == null ^ this.currentShardCount() == null) {
            return false;
        }
        if (other.currentShardCount() != null && !other.currentShardCount().equals(this.currentShardCount())) {
            return false;
        }
        if (other.targetShardCount() == null ^ this.targetShardCount() == null) {
            return false;
        }
        return other.targetShardCount() == null || other.targetShardCount().equals(this.targetShardCount());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.streamName() != null) {
            sb.append("StreamName: ").append(this.streamName()).append(",");
        }
        if (this.currentShardCount() != null) {
            sb.append("CurrentShardCount: ").append(this.currentShardCount()).append(",");
        }
        if (this.targetShardCount() != null) {
            sb.append("TargetShardCount: ").append(this.targetShardCount()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.of(clazz.cast(this.streamName()));
            }
            case "CurrentShardCount": {
                return Optional.of(clazz.cast(this.currentShardCount()));
            }
            case "TargetShardCount": {
                return Optional.of(clazz.cast(this.targetShardCount()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String streamName;
        private Integer currentShardCount;
        private Integer targetShardCount;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateShardCountResponse model) {
            this.streamName(model.streamName);
            this.currentShardCount(model.currentShardCount);
            this.targetShardCount(model.targetShardCount);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Integer getCurrentShardCount() {
            return this.currentShardCount;
        }

        @Override
        public final Builder currentShardCount(Integer currentShardCount) {
            this.currentShardCount = currentShardCount;
            return this;
        }

        public final void setCurrentShardCount(Integer currentShardCount) {
            this.currentShardCount = currentShardCount;
        }

        public final Integer getTargetShardCount() {
            return this.targetShardCount;
        }

        @Override
        public final Builder targetShardCount(Integer targetShardCount) {
            this.targetShardCount = targetShardCount;
            return this;
        }

        public final void setTargetShardCount(Integer targetShardCount) {
            this.targetShardCount = targetShardCount;
        }

        public UpdateShardCountResponse build() {
            return new UpdateShardCountResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateShardCountResponse> {
        public Builder streamName(String var1);

        public Builder currentShardCount(Integer var1);

        public Builder targetShardCount(Integer var1);
    }
}

