/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutRecordResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, PutRecordResponse> {
    private final String shardId;
    private final String sequenceNumber;

    private PutRecordResponse(BuilderImpl builder) {
        this.shardId = builder.shardId;
        this.sequenceNumber = builder.sequenceNumber;
    }

    public String shardId() {
        return this.shardId;
    }

    public String sequenceNumber() {
        return this.sequenceNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.shardId() == null ? 0 : this.shardId().hashCode());
        hashCode = 31 * hashCode + (this.sequenceNumber() == null ? 0 : this.sequenceNumber().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordResponse)) {
            return false;
        }
        PutRecordResponse other = (PutRecordResponse)((Object)obj);
        if (other.shardId() == null ^ this.shardId() == null) {
            return false;
        }
        if (other.shardId() != null && !other.shardId().equals(this.shardId())) {
            return false;
        }
        if (other.sequenceNumber() == null ^ this.sequenceNumber() == null) {
            return false;
        }
        return other.sequenceNumber() == null || other.sequenceNumber().equals(this.sequenceNumber());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.shardId() != null) {
            sb.append("ShardId: ").append(this.shardId()).append(",");
        }
        if (this.sequenceNumber() != null) {
            sb.append("SequenceNumber: ").append(this.sequenceNumber()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ShardId": {
                return Optional.of(clazz.cast(this.shardId()));
            }
            case "SequenceNumber": {
                return Optional.of(clazz.cast(this.sequenceNumber()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String shardId;
        private String sequenceNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordResponse model) {
            this.shardId(model.shardId);
            this.sequenceNumber(model.sequenceNumber);
        }

        public final String getShardId() {
            return this.shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        public final String getSequenceNumber() {
            return this.sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        public PutRecordResponse build() {
            return new PutRecordResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutRecordResponse> {
        public Builder shardId(String var1);

        public Builder sequenceNumber(String var1);
    }
}

