/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MergeShardsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, MergeShardsRequest> {
    private final String streamName;
    private final String shardToMerge;
    private final String adjacentShardToMerge;

    private MergeShardsRequest(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.shardToMerge = builder.shardToMerge;
        this.adjacentShardToMerge = builder.adjacentShardToMerge;
    }

    public String streamName() {
        return this.streamName;
    }

    public String shardToMerge() {
        return this.shardToMerge;
    }

    public String adjacentShardToMerge() {
        return this.adjacentShardToMerge;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.streamName() == null ? 0 : this.streamName().hashCode());
        hashCode = 31 * hashCode + (this.shardToMerge() == null ? 0 : this.shardToMerge().hashCode());
        hashCode = 31 * hashCode + (this.adjacentShardToMerge() == null ? 0 : this.adjacentShardToMerge().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeShardsRequest)) {
            return false;
        }
        MergeShardsRequest other = (MergeShardsRequest)((Object)obj);
        if (other.streamName() == null ^ this.streamName() == null) {
            return false;
        }
        if (other.streamName() != null && !other.streamName().equals(this.streamName())) {
            return false;
        }
        if (other.shardToMerge() == null ^ this.shardToMerge() == null) {
            return false;
        }
        if (other.shardToMerge() != null && !other.shardToMerge().equals(this.shardToMerge())) {
            return false;
        }
        if (other.adjacentShardToMerge() == null ^ this.adjacentShardToMerge() == null) {
            return false;
        }
        return other.adjacentShardToMerge() == null || other.adjacentShardToMerge().equals(this.adjacentShardToMerge());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.streamName() != null) {
            sb.append("StreamName: ").append(this.streamName()).append(",");
        }
        if (this.shardToMerge() != null) {
            sb.append("ShardToMerge: ").append(this.shardToMerge()).append(",");
        }
        if (this.adjacentShardToMerge() != null) {
            sb.append("AdjacentShardToMerge: ").append(this.adjacentShardToMerge()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.of(clazz.cast(this.streamName()));
            }
            case "ShardToMerge": {
                return Optional.of(clazz.cast(this.shardToMerge()));
            }
            case "AdjacentShardToMerge": {
                return Optional.of(clazz.cast(this.adjacentShardToMerge()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String streamName;
        private String shardToMerge;
        private String adjacentShardToMerge;

        private BuilderImpl() {
        }

        private BuilderImpl(MergeShardsRequest model) {
            this.streamName(model.streamName);
            this.shardToMerge(model.shardToMerge);
            this.adjacentShardToMerge(model.adjacentShardToMerge);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getShardToMerge() {
            return this.shardToMerge;
        }

        @Override
        public final Builder shardToMerge(String shardToMerge) {
            this.shardToMerge = shardToMerge;
            return this;
        }

        public final void setShardToMerge(String shardToMerge) {
            this.shardToMerge = shardToMerge;
        }

        public final String getAdjacentShardToMerge() {
            return this.adjacentShardToMerge;
        }

        @Override
        public final Builder adjacentShardToMerge(String adjacentShardToMerge) {
            this.adjacentShardToMerge = adjacentShardToMerge;
            return this;
        }

        public final void setAdjacentShardToMerge(String adjacentShardToMerge) {
            this.adjacentShardToMerge = adjacentShardToMerge;
        }

        public MergeShardsRequest build() {
            return new MergeShardsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MergeShardsRequest> {
        public Builder streamName(String var1);

        public Builder shardToMerge(String var1);

        public Builder adjacentShardToMerge(String var1);
    }
}

