/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListStreamsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListStreamsRequest> {
    private final Integer limit;
    private final String exclusiveStartStreamName;

    private ListStreamsRequest(BuilderImpl builder) {
        this.limit = builder.limit;
        this.exclusiveStartStreamName = builder.exclusiveStartStreamName;
    }

    public Integer limit() {
        return this.limit;
    }

    public String exclusiveStartStreamName() {
        return this.exclusiveStartStreamName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.limit() == null ? 0 : this.limit().hashCode());
        hashCode = 31 * hashCode + (this.exclusiveStartStreamName() == null ? 0 : this.exclusiveStartStreamName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamsRequest)) {
            return false;
        }
        ListStreamsRequest other = (ListStreamsRequest)((Object)obj);
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.exclusiveStartStreamName() == null ^ this.exclusiveStartStreamName() == null) {
            return false;
        }
        return other.exclusiveStartStreamName() == null || other.exclusiveStartStreamName().equals(this.exclusiveStartStreamName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.exclusiveStartStreamName() != null) {
            sb.append("ExclusiveStartStreamName: ").append(this.exclusiveStartStreamName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "ExclusiveStartStreamName": {
                return Optional.of(clazz.cast(this.exclusiveStartStreamName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer limit;
        private String exclusiveStartStreamName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamsRequest model) {
            this.limit(model.limit);
            this.exclusiveStartStreamName(model.exclusiveStartStreamName);
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getExclusiveStartStreamName() {
            return this.exclusiveStartStreamName;
        }

        @Override
        public final Builder exclusiveStartStreamName(String exclusiveStartStreamName) {
            this.exclusiveStartStreamName = exclusiveStartStreamName;
            return this;
        }

        public final void setExclusiveStartStreamName(String exclusiveStartStreamName) {
            this.exclusiveStartStreamName = exclusiveStartStreamName;
        }

        public ListStreamsRequest build() {
            return new ListStreamsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListStreamsRequest> {
        public Builder limit(Integer var1);

        public Builder exclusiveStartStreamName(String var1);
    }
}

