/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.firehose.model.DestinationDescription;
import software.amazon.awssdk.services.firehose.transform.ElasticsearchDestinationDescriptionUnmarshaller;
import software.amazon.awssdk.services.firehose.transform.ExtendedS3DestinationDescriptionUnmarshaller;
import software.amazon.awssdk.services.firehose.transform.RedshiftDestinationDescriptionUnmarshaller;
import software.amazon.awssdk.services.firehose.transform.S3DestinationDescriptionUnmarshaller;

public class DestinationDescriptionUnmarshaller
implements Unmarshaller<DestinationDescription, JsonUnmarshallerContext> {
    private static final DestinationDescriptionUnmarshaller INSTANCE = new DestinationDescriptionUnmarshaller();

    public DestinationDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        DestinationDescription.Builder destinationDescriptionBuilder = DestinationDescription.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("DestinationId", targetDepth)) {
                    context.nextToken();
                    destinationDescriptionBuilder.destinationId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("S3DestinationDescription", targetDepth)) {
                    context.nextToken();
                    destinationDescriptionBuilder.s3DestinationDescription(S3DestinationDescriptionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ExtendedS3DestinationDescription", targetDepth)) {
                    context.nextToken();
                    destinationDescriptionBuilder.extendedS3DestinationDescription(ExtendedS3DestinationDescriptionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("RedshiftDestinationDescription", targetDepth)) {
                    context.nextToken();
                    destinationDescriptionBuilder.redshiftDestinationDescription(RedshiftDestinationDescriptionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ElasticsearchDestinationDescription", targetDepth)) {
                    context.nextToken();
                    destinationDescriptionBuilder.elasticsearchDestinationDescription(ElasticsearchDestinationDescriptionUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (DestinationDescription)destinationDescriptionBuilder.build();
    }

    public static DestinationDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

