/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;
import software.amazon.awssdk.services.firehose.model.ElasticsearchBufferingHints;
import software.amazon.awssdk.services.firehose.model.ElasticsearchIndexRotationPeriod;
import software.amazon.awssdk.services.firehose.model.ElasticsearchRetryOptions;
import software.amazon.awssdk.services.firehose.model.ElasticsearchS3BackupMode;
import software.amazon.awssdk.services.firehose.model.ProcessingConfiguration;
import software.amazon.awssdk.services.firehose.model.S3DestinationConfiguration;
import software.amazon.awssdk.services.firehose.transform.ElasticsearchDestinationConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ElasticsearchDestinationConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, ElasticsearchDestinationConfiguration> {
    private final String roleARN;
    private final String domainARN;
    private final String indexName;
    private final String typeName;
    private final String indexRotationPeriod;
    private final ElasticsearchBufferingHints bufferingHints;
    private final ElasticsearchRetryOptions retryOptions;
    private final String s3BackupMode;
    private final S3DestinationConfiguration s3Configuration;
    private final ProcessingConfiguration processingConfiguration;
    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;

    private ElasticsearchDestinationConfiguration(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.domainARN = builder.domainARN;
        this.indexName = builder.indexName;
        this.typeName = builder.typeName;
        this.indexRotationPeriod = builder.indexRotationPeriod;
        this.bufferingHints = builder.bufferingHints;
        this.retryOptions = builder.retryOptions;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3Configuration = builder.s3Configuration;
        this.processingConfiguration = builder.processingConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public String domainARN() {
        return this.domainARN;
    }

    public String indexName() {
        return this.indexName;
    }

    public String typeName() {
        return this.typeName;
    }

    public ElasticsearchIndexRotationPeriod indexRotationPeriod() {
        return ElasticsearchIndexRotationPeriod.fromValue(this.indexRotationPeriod);
    }

    public String indexRotationPeriodString() {
        return this.indexRotationPeriod;
    }

    public ElasticsearchBufferingHints bufferingHints() {
        return this.bufferingHints;
    }

    public ElasticsearchRetryOptions retryOptions() {
        return this.retryOptions;
    }

    public ElasticsearchS3BackupMode s3BackupMode() {
        return ElasticsearchS3BackupMode.fromValue(this.s3BackupMode);
    }

    public String s3BackupModeString() {
        return this.s3BackupMode;
    }

    public S3DestinationConfiguration s3Configuration() {
        return this.s3Configuration;
    }

    public ProcessingConfiguration processingConfiguration() {
        return this.processingConfiguration;
    }

    public CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.roleARN() == null ? 0 : this.roleARN().hashCode());
        hashCode = 31 * hashCode + (this.domainARN() == null ? 0 : this.domainARN().hashCode());
        hashCode = 31 * hashCode + (this.indexName() == null ? 0 : this.indexName().hashCode());
        hashCode = 31 * hashCode + (this.typeName() == null ? 0 : this.typeName().hashCode());
        hashCode = 31 * hashCode + (this.indexRotationPeriodString() == null ? 0 : this.indexRotationPeriodString().hashCode());
        hashCode = 31 * hashCode + (this.bufferingHints() == null ? 0 : this.bufferingHints().hashCode());
        hashCode = 31 * hashCode + (this.retryOptions() == null ? 0 : this.retryOptions().hashCode());
        hashCode = 31 * hashCode + (this.s3BackupModeString() == null ? 0 : this.s3BackupModeString().hashCode());
        hashCode = 31 * hashCode + (this.s3Configuration() == null ? 0 : this.s3Configuration().hashCode());
        hashCode = 31 * hashCode + (this.processingConfiguration() == null ? 0 : this.processingConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.cloudWatchLoggingOptions() == null ? 0 : this.cloudWatchLoggingOptions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchDestinationConfiguration)) {
            return false;
        }
        ElasticsearchDestinationConfiguration other = (ElasticsearchDestinationConfiguration)obj;
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.domainARN() == null ^ this.domainARN() == null) {
            return false;
        }
        if (other.domainARN() != null && !other.domainARN().equals(this.domainARN())) {
            return false;
        }
        if (other.indexName() == null ^ this.indexName() == null) {
            return false;
        }
        if (other.indexName() != null && !other.indexName().equals(this.indexName())) {
            return false;
        }
        if (other.typeName() == null ^ this.typeName() == null) {
            return false;
        }
        if (other.typeName() != null && !other.typeName().equals(this.typeName())) {
            return false;
        }
        if (other.indexRotationPeriodString() == null ^ this.indexRotationPeriodString() == null) {
            return false;
        }
        if (other.indexRotationPeriodString() != null && !other.indexRotationPeriodString().equals(this.indexRotationPeriodString())) {
            return false;
        }
        if (other.bufferingHints() == null ^ this.bufferingHints() == null) {
            return false;
        }
        if (other.bufferingHints() != null && !other.bufferingHints().equals(this.bufferingHints())) {
            return false;
        }
        if (other.retryOptions() == null ^ this.retryOptions() == null) {
            return false;
        }
        if (other.retryOptions() != null && !other.retryOptions().equals(this.retryOptions())) {
            return false;
        }
        if (other.s3BackupModeString() == null ^ this.s3BackupModeString() == null) {
            return false;
        }
        if (other.s3BackupModeString() != null && !other.s3BackupModeString().equals(this.s3BackupModeString())) {
            return false;
        }
        if (other.s3Configuration() == null ^ this.s3Configuration() == null) {
            return false;
        }
        if (other.s3Configuration() != null && !other.s3Configuration().equals(this.s3Configuration())) {
            return false;
        }
        if (other.processingConfiguration() == null ^ this.processingConfiguration() == null) {
            return false;
        }
        if (other.processingConfiguration() != null && !other.processingConfiguration().equals(this.processingConfiguration())) {
            return false;
        }
        if (other.cloudWatchLoggingOptions() == null ^ this.cloudWatchLoggingOptions() == null) {
            return false;
        }
        return other.cloudWatchLoggingOptions() == null || other.cloudWatchLoggingOptions().equals(this.cloudWatchLoggingOptions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.roleARN() != null) {
            sb.append("RoleARN: ").append(this.roleARN()).append(",");
        }
        if (this.domainARN() != null) {
            sb.append("DomainARN: ").append(this.domainARN()).append(",");
        }
        if (this.indexName() != null) {
            sb.append("IndexName: ").append(this.indexName()).append(",");
        }
        if (this.typeName() != null) {
            sb.append("TypeName: ").append(this.typeName()).append(",");
        }
        if (this.indexRotationPeriodString() != null) {
            sb.append("IndexRotationPeriod: ").append(this.indexRotationPeriodString()).append(",");
        }
        if (this.bufferingHints() != null) {
            sb.append("BufferingHints: ").append(this.bufferingHints()).append(",");
        }
        if (this.retryOptions() != null) {
            sb.append("RetryOptions: ").append(this.retryOptions()).append(",");
        }
        if (this.s3BackupModeString() != null) {
            sb.append("S3BackupMode: ").append(this.s3BackupModeString()).append(",");
        }
        if (this.s3Configuration() != null) {
            sb.append("S3Configuration: ").append(this.s3Configuration()).append(",");
        }
        if (this.processingConfiguration() != null) {
            sb.append("ProcessingConfiguration: ").append(this.processingConfiguration()).append(",");
        }
        if (this.cloudWatchLoggingOptions() != null) {
            sb.append("CloudWatchLoggingOptions: ").append(this.cloudWatchLoggingOptions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleARN": {
                return Optional.of(clazz.cast(this.roleARN()));
            }
            case "DomainARN": {
                return Optional.of(clazz.cast(this.domainARN()));
            }
            case "IndexName": {
                return Optional.of(clazz.cast(this.indexName()));
            }
            case "TypeName": {
                return Optional.of(clazz.cast(this.typeName()));
            }
            case "IndexRotationPeriod": {
                return Optional.of(clazz.cast(this.indexRotationPeriodString()));
            }
            case "BufferingHints": {
                return Optional.of(clazz.cast(this.bufferingHints()));
            }
            case "RetryOptions": {
                return Optional.of(clazz.cast(this.retryOptions()));
            }
            case "S3BackupMode": {
                return Optional.of(clazz.cast(this.s3BackupModeString()));
            }
            case "S3Configuration": {
                return Optional.of(clazz.cast(this.s3Configuration()));
            }
            case "ProcessingConfiguration": {
                return Optional.of(clazz.cast(this.processingConfiguration()));
            }
            case "CloudWatchLoggingOptions": {
                return Optional.of(clazz.cast(this.cloudWatchLoggingOptions()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ElasticsearchDestinationConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleARN;
        private String domainARN;
        private String indexName;
        private String typeName;
        private String indexRotationPeriod;
        private ElasticsearchBufferingHints bufferingHints;
        private ElasticsearchRetryOptions retryOptions;
        private String s3BackupMode;
        private S3DestinationConfiguration s3Configuration;
        private ProcessingConfiguration processingConfiguration;
        private CloudWatchLoggingOptions cloudWatchLoggingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchDestinationConfiguration model) {
            this.roleARN(model.roleARN);
            this.domainARN(model.domainARN);
            this.indexName(model.indexName);
            this.typeName(model.typeName);
            this.indexRotationPeriod(model.indexRotationPeriod);
            this.bufferingHints(model.bufferingHints);
            this.retryOptions(model.retryOptions);
            this.s3BackupMode(model.s3BackupMode);
            this.s3Configuration(model.s3Configuration);
            this.processingConfiguration(model.processingConfiguration);
            this.cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getDomainARN() {
            return this.domainARN;
        }

        @Override
        public final Builder domainARN(String domainARN) {
            this.domainARN = domainARN;
            return this;
        }

        public final void setDomainARN(String domainARN) {
            this.domainARN = domainARN;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getIndexRotationPeriod() {
            return this.indexRotationPeriod;
        }

        @Override
        public final Builder indexRotationPeriod(String indexRotationPeriod) {
            this.indexRotationPeriod = indexRotationPeriod;
            return this;
        }

        @Override
        public final Builder indexRotationPeriod(ElasticsearchIndexRotationPeriod indexRotationPeriod) {
            this.indexRotationPeriod(indexRotationPeriod.toString());
            return this;
        }

        public final void setIndexRotationPeriod(String indexRotationPeriod) {
            this.indexRotationPeriod = indexRotationPeriod;
        }

        public final ElasticsearchBufferingHints.Builder getBufferingHints() {
            return this.bufferingHints != null ? this.bufferingHints.toBuilder() : null;
        }

        @Override
        public final Builder bufferingHints(ElasticsearchBufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final void setBufferingHints(ElasticsearchBufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        public final ElasticsearchRetryOptions.Builder getRetryOptions() {
            return this.retryOptions != null ? this.retryOptions.toBuilder() : null;
        }

        @Override
        public final Builder retryOptions(ElasticsearchRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final void setRetryOptions(ElasticsearchRetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        public final String getS3BackupMode() {
            return this.s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(ElasticsearchS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode.toString());
            return this;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        public final S3DestinationConfiguration.Builder getS3Configuration() {
            return this.s3Configuration != null ? this.s3Configuration.toBuilder() : null;
        }

        @Override
        public final Builder s3Configuration(S3DestinationConfiguration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public final void setS3Configuration(S3DestinationConfiguration.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return this.processingConfiguration != null ? this.processingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        public ElasticsearchDestinationConfiguration build() {
            return new ElasticsearchDestinationConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ElasticsearchDestinationConfiguration> {
        public Builder roleARN(String var1);

        public Builder domainARN(String var1);

        public Builder indexName(String var1);

        public Builder typeName(String var1);

        public Builder indexRotationPeriod(String var1);

        public Builder indexRotationPeriod(ElasticsearchIndexRotationPeriod var1);

        public Builder bufferingHints(ElasticsearchBufferingHints var1);

        public Builder retryOptions(ElasticsearchRetryOptions var1);

        public Builder s3BackupMode(String var1);

        public Builder s3BackupMode(ElasticsearchS3BackupMode var1);

        public Builder s3Configuration(S3DestinationConfiguration var1);

        public Builder processingConfiguration(ProcessingConfiguration var1);

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions var1);
    }
}

