/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.CopyCommandMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CopyCommand
implements StructuredPojo,
ToCopyableBuilder<Builder, CopyCommand> {
    private final String dataTableName;
    private final String dataTableColumns;
    private final String copyOptions;

    private CopyCommand(BuilderImpl builder) {
        this.dataTableName = builder.dataTableName;
        this.dataTableColumns = builder.dataTableColumns;
        this.copyOptions = builder.copyOptions;
    }

    public String dataTableName() {
        return this.dataTableName;
    }

    public String dataTableColumns() {
        return this.dataTableColumns;
    }

    public String copyOptions() {
        return this.copyOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dataTableName() == null ? 0 : this.dataTableName().hashCode());
        hashCode = 31 * hashCode + (this.dataTableColumns() == null ? 0 : this.dataTableColumns().hashCode());
        hashCode = 31 * hashCode + (this.copyOptions() == null ? 0 : this.copyOptions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyCommand)) {
            return false;
        }
        CopyCommand other = (CopyCommand)obj;
        if (other.dataTableName() == null ^ this.dataTableName() == null) {
            return false;
        }
        if (other.dataTableName() != null && !other.dataTableName().equals(this.dataTableName())) {
            return false;
        }
        if (other.dataTableColumns() == null ^ this.dataTableColumns() == null) {
            return false;
        }
        if (other.dataTableColumns() != null && !other.dataTableColumns().equals(this.dataTableColumns())) {
            return false;
        }
        if (other.copyOptions() == null ^ this.copyOptions() == null) {
            return false;
        }
        return other.copyOptions() == null || other.copyOptions().equals(this.copyOptions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dataTableName() != null) {
            sb.append("DataTableName: ").append(this.dataTableName()).append(",");
        }
        if (this.dataTableColumns() != null) {
            sb.append("DataTableColumns: ").append(this.dataTableColumns()).append(",");
        }
        if (this.copyOptions() != null) {
            sb.append("CopyOptions: ").append(this.copyOptions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataTableName": {
                return Optional.of(clazz.cast(this.dataTableName()));
            }
            case "DataTableColumns": {
                return Optional.of(clazz.cast(this.dataTableColumns()));
            }
            case "CopyOptions": {
                return Optional.of(clazz.cast(this.copyOptions()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CopyCommandMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataTableName;
        private String dataTableColumns;
        private String copyOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyCommand model) {
            this.dataTableName(model.dataTableName);
            this.dataTableColumns(model.dataTableColumns);
            this.copyOptions(model.copyOptions);
        }

        public final String getDataTableName() {
            return this.dataTableName;
        }

        @Override
        public final Builder dataTableName(String dataTableName) {
            this.dataTableName = dataTableName;
            return this;
        }

        public final void setDataTableName(String dataTableName) {
            this.dataTableName = dataTableName;
        }

        public final String getDataTableColumns() {
            return this.dataTableColumns;
        }

        @Override
        public final Builder dataTableColumns(String dataTableColumns) {
            this.dataTableColumns = dataTableColumns;
            return this;
        }

        public final void setDataTableColumns(String dataTableColumns) {
            this.dataTableColumns = dataTableColumns;
        }

        public final String getCopyOptions() {
            return this.copyOptions;
        }

        @Override
        public final Builder copyOptions(String copyOptions) {
            this.copyOptions = copyOptions;
            return this;
        }

        public final void setCopyOptions(String copyOptions) {
            this.copyOptions = copyOptions;
        }

        public CopyCommand build() {
            return new CopyCommand(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CopyCommand> {
        public Builder dataTableName(String var1);

        public Builder dataTableColumns(String var1);

        public Builder copyOptions(String var1);
    }
}

