/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.kinesisanalytics.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * S3ReferenceDataSourceDescription JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class S3ReferenceDataSourceDescriptionUnmarshaller implements
        Unmarshaller<S3ReferenceDataSourceDescription, JsonUnmarshallerContext> {

    public S3ReferenceDataSourceDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3ReferenceDataSourceDescription.Builder s3ReferenceDataSourceDescriptionBuilder = S3ReferenceDataSourceDescription
                .builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("BucketARN", targetDepth)) {
                    context.nextToken();
                    s3ReferenceDataSourceDescriptionBuilder.bucketARN(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("FileKey", targetDepth)) {
                    context.nextToken();
                    s3ReferenceDataSourceDescriptionBuilder.fileKey(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ReferenceRoleARN", targetDepth)) {
                    context.nextToken();
                    s3ReferenceDataSourceDescriptionBuilder.referenceRoleARN(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return s3ReferenceDataSourceDescriptionBuilder.build();
    }

    private static final S3ReferenceDataSourceDescriptionUnmarshaller INSTANCE = new S3ReferenceDataSourceDescriptionUnmarshaller();

    public static S3ReferenceDataSourceDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}
