/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.OutputDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the application output configuration, which includes the in-application stream name and the destination
 * where the stream data is written. The destination can be an Amazon Kinesis stream or an Amazon Kinesis Firehose
 * delivery stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class OutputDescription implements StructuredPojo, ToCopyableBuilder<OutputDescription.Builder, OutputDescription> {
    private final String outputId;

    private final String name;

    private final KinesisStreamsOutputDescription kinesisStreamsOutputDescription;

    private final KinesisFirehoseOutputDescription kinesisFirehoseOutputDescription;

    private final DestinationSchema destinationSchema;

    private OutputDescription(BuilderImpl builder) {
        this.outputId = builder.outputId;
        this.name = builder.name;
        this.kinesisStreamsOutputDescription = builder.kinesisStreamsOutputDescription;
        this.kinesisFirehoseOutputDescription = builder.kinesisFirehoseOutputDescription;
        this.destinationSchema = builder.destinationSchema;
    }

    /**
     * <p>
     * A unique identifier for the output configuration.
     * </p>
     * 
     * @return A unique identifier for the output configuration.
     */
    public String outputId() {
        return outputId;
    }

    /**
     * <p>
     * Name of the in-application stream configured as output.
     * </p>
     * 
     * @return Name of the in-application stream configured as output.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Describes Amazon Kinesis stream configured as the destination where output is written.
     * </p>
     * 
     * @return Describes Amazon Kinesis stream configured as the destination where output is written.
     */
    public KinesisStreamsOutputDescription kinesisStreamsOutputDescription() {
        return kinesisStreamsOutputDescription;
    }

    /**
     * <p>
     * Describes the Amazon Kinesis Firehose delivery stream configured as the destination where output is written.
     * </p>
     * 
     * @return Describes the Amazon Kinesis Firehose delivery stream configured as the destination where output is
     *         written.
     */
    public KinesisFirehoseOutputDescription kinesisFirehoseOutputDescription() {
        return kinesisFirehoseOutputDescription;
    }

    /**
     * <p>
     * Data format used for writing data to the destination.
     * </p>
     * 
     * @return Data format used for writing data to the destination.
     */
    public DestinationSchema destinationSchema() {
        return destinationSchema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((outputId() == null) ? 0 : outputId().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode
                + ((kinesisStreamsOutputDescription() == null) ? 0 : kinesisStreamsOutputDescription().hashCode());
        hashCode = 31 * hashCode
                + ((kinesisFirehoseOutputDescription() == null) ? 0 : kinesisFirehoseOutputDescription().hashCode());
        hashCode = 31 * hashCode + ((destinationSchema() == null) ? 0 : destinationSchema().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputDescription)) {
            return false;
        }
        OutputDescription other = (OutputDescription) obj;
        if (other.outputId() == null ^ this.outputId() == null) {
            return false;
        }
        if (other.outputId() != null && !other.outputId().equals(this.outputId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.kinesisStreamsOutputDescription() == null ^ this.kinesisStreamsOutputDescription() == null) {
            return false;
        }
        if (other.kinesisStreamsOutputDescription() != null
                && !other.kinesisStreamsOutputDescription().equals(this.kinesisStreamsOutputDescription())) {
            return false;
        }
        if (other.kinesisFirehoseOutputDescription() == null ^ this.kinesisFirehoseOutputDescription() == null) {
            return false;
        }
        if (other.kinesisFirehoseOutputDescription() != null
                && !other.kinesisFirehoseOutputDescription().equals(this.kinesisFirehoseOutputDescription())) {
            return false;
        }
        if (other.destinationSchema() == null ^ this.destinationSchema() == null) {
            return false;
        }
        if (other.destinationSchema() != null && !other.destinationSchema().equals(this.destinationSchema())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (outputId() != null) {
            sb.append("OutputId: ").append(outputId()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (kinesisStreamsOutputDescription() != null) {
            sb.append("KinesisStreamsOutputDescription: ").append(kinesisStreamsOutputDescription()).append(",");
        }
        if (kinesisFirehoseOutputDescription() != null) {
            sb.append("KinesisFirehoseOutputDescription: ").append(kinesisFirehoseOutputDescription()).append(",");
        }
        if (destinationSchema() != null) {
            sb.append("DestinationSchema: ").append(destinationSchema()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutputId":
            return Optional.of(clazz.cast(outputId()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "KinesisStreamsOutputDescription":
            return Optional.of(clazz.cast(kinesisStreamsOutputDescription()));
        case "KinesisFirehoseOutputDescription":
            return Optional.of(clazz.cast(kinesisFirehoseOutputDescription()));
        case "DestinationSchema":
            return Optional.of(clazz.cast(destinationSchema()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutputDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, OutputDescription> {
        /**
         * <p>
         * A unique identifier for the output configuration.
         * </p>
         * 
         * @param outputId
         *        A unique identifier for the output configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputId(String outputId);

        /**
         * <p>
         * Name of the in-application stream configured as output.
         * </p>
         * 
         * @param name
         *        Name of the in-application stream configured as output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Describes Amazon Kinesis stream configured as the destination where output is written.
         * </p>
         * 
         * @param kinesisStreamsOutputDescription
         *        Describes Amazon Kinesis stream configured as the destination where output is written.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamsOutputDescription(KinesisStreamsOutputDescription kinesisStreamsOutputDescription);

        /**
         * <p>
         * Describes the Amazon Kinesis Firehose delivery stream configured as the destination where output is written.
         * </p>
         * 
         * @param kinesisFirehoseOutputDescription
         *        Describes the Amazon Kinesis Firehose delivery stream configured as the destination where output is
         *        written.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisFirehoseOutputDescription(KinesisFirehoseOutputDescription kinesisFirehoseOutputDescription);

        /**
         * <p>
         * Data format used for writing data to the destination.
         * </p>
         * 
         * @param destinationSchema
         *        Data format used for writing data to the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationSchema(DestinationSchema destinationSchema);
    }

    static final class BuilderImpl implements Builder {
        private String outputId;

        private String name;

        private KinesisStreamsOutputDescription kinesisStreamsOutputDescription;

        private KinesisFirehoseOutputDescription kinesisFirehoseOutputDescription;

        private DestinationSchema destinationSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputDescription model) {
            outputId(model.outputId);
            name(model.name);
            kinesisStreamsOutputDescription(model.kinesisStreamsOutputDescription);
            kinesisFirehoseOutputDescription(model.kinesisFirehoseOutputDescription);
            destinationSchema(model.destinationSchema);
        }

        public final String getOutputId() {
            return outputId;
        }

        @Override
        public final Builder outputId(String outputId) {
            this.outputId = outputId;
            return this;
        }

        public final void setOutputId(String outputId) {
            this.outputId = outputId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final KinesisStreamsOutputDescription.Builder getKinesisStreamsOutputDescription() {
            return kinesisStreamsOutputDescription != null ? kinesisStreamsOutputDescription.toBuilder() : null;
        }

        @Override
        public final Builder kinesisStreamsOutputDescription(KinesisStreamsOutputDescription kinesisStreamsOutputDescription) {
            this.kinesisStreamsOutputDescription = kinesisStreamsOutputDescription;
            return this;
        }

        public final void setKinesisStreamsOutputDescription(
                KinesisStreamsOutputDescription.BuilderImpl kinesisStreamsOutputDescription) {
            this.kinesisStreamsOutputDescription = kinesisStreamsOutputDescription != null ? kinesisStreamsOutputDescription
                    .build() : null;
        }

        public final KinesisFirehoseOutputDescription.Builder getKinesisFirehoseOutputDescription() {
            return kinesisFirehoseOutputDescription != null ? kinesisFirehoseOutputDescription.toBuilder() : null;
        }

        @Override
        public final Builder kinesisFirehoseOutputDescription(KinesisFirehoseOutputDescription kinesisFirehoseOutputDescription) {
            this.kinesisFirehoseOutputDescription = kinesisFirehoseOutputDescription;
            return this;
        }

        public final void setKinesisFirehoseOutputDescription(
                KinesisFirehoseOutputDescription.BuilderImpl kinesisFirehoseOutputDescription) {
            this.kinesisFirehoseOutputDescription = kinesisFirehoseOutputDescription != null ? kinesisFirehoseOutputDescription
                    .build() : null;
        }

        public final DestinationSchema.Builder getDestinationSchema() {
            return destinationSchema != null ? destinationSchema.toBuilder() : null;
        }

        @Override
        public final Builder destinationSchema(DestinationSchema destinationSchema) {
            this.destinationSchema = destinationSchema;
            return this;
        }

        public final void setDestinationSchema(DestinationSchema.BuilderImpl destinationSchema) {
            this.destinationSchema = destinationSchema != null ? destinationSchema.build() : null;
        }

        @Override
        public OutputDescription build() {
            return new OutputDescription(this);
        }
    }
}
