/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.InputMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When you configure the application input, you specify the streaming source, the in-application stream name that is
 * created, and the mapping between the two. For more information, see <a
 * href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application
 * Input</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Input implements StructuredPojo, ToCopyableBuilder<Input.Builder, Input> {
    private final String namePrefix;

    private final KinesisStreamsInput kinesisStreamsInput;

    private final KinesisFirehoseInput kinesisFirehoseInput;

    private final InputParallelism inputParallelism;

    private final SourceSchema inputSchema;

    private Input(BuilderImpl builder) {
        this.namePrefix = builder.namePrefix;
        this.kinesisStreamsInput = builder.kinesisStreamsInput;
        this.kinesisFirehoseInput = builder.kinesisFirehoseInput;
        this.inputParallelism = builder.inputParallelism;
        this.inputSchema = builder.inputSchema;
    }

    /**
     * <p>
     * Name prefix to use when creating in-application stream. Suppose you specify a prefix "MyInApplicationStream".
     * Amazon Kinesis Analytics will then create one or more (as per the <code>InputParallelism</code> count you
     * specified) in-application streams with names "MyInApplicationStream_001", "MyInApplicationStream_002" and so on.
     * </p>
     * 
     * @return Name prefix to use when creating in-application stream. Suppose you specify a prefix
     *         "MyInApplicationStream". Amazon Kinesis Analytics will then create one or more (as per the
     *         <code>InputParallelism</code> count you specified) in-application streams with names
     *         "MyInApplicationStream_001", "MyInApplicationStream_002" and so on.
     */
    public String namePrefix() {
        return namePrefix;
    }

    /**
     * <p>
     * If the streaming source is an Amazon Kinesis stream, identifies the stream's Amazon Resource Name (ARN) and an
     * IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.
     * </p>
     * 
     * @return If the streaming source is an Amazon Kinesis stream, identifies the stream's Amazon Resource Name (ARN)
     *         and an IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.
     */
    public KinesisStreamsInput kinesisStreamsInput() {
        return kinesisStreamsInput;
    }

    /**
     * <p>
     * If the streaming source is an Amazon Kinesis Firehose delivery stream, identifies the Firehose delivery stream's
     * ARN and an IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.
     * </p>
     * 
     * @return If the streaming source is an Amazon Kinesis Firehose delivery stream, identifies the Firehose delivery
     *         stream's ARN and an IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.
     */
    public KinesisFirehoseInput kinesisFirehoseInput() {
        return kinesisFirehoseInput;
    }

    /**
     * <p>
     * Describes the number of in-application streams to create.
     * </p>
     * <p>
     * Data from your source will be routed to these in-application input streams.
     * </p>
     * <p>
     * (see <a href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring
     * Application Input</a>.
     * </p>
     * 
     * @return Describes the number of in-application streams to create. </p>
     *         <p>
     *         Data from your source will be routed to these in-application input streams.
     *         </p>
     *         <p>
     *         (see <a href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring
     *         Application Input</a>.
     */
    public InputParallelism inputParallelism() {
        return inputParallelism;
    }

    /**
     * <p>
     * Describes the format of the data in the streaming source, and how each data element maps to corresponding columns
     * in the in-application stream that is being created.
     * </p>
     * <p>
     * Also used to describe the format of the reference data source.
     * </p>
     * 
     * @return Describes the format of the data in the streaming source, and how each data element maps to corresponding
     *         columns in the in-application stream that is being created.</p>
     *         <p>
     *         Also used to describe the format of the reference data source.
     */
    public SourceSchema inputSchema() {
        return inputSchema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((namePrefix() == null) ? 0 : namePrefix().hashCode());
        hashCode = 31 * hashCode + ((kinesisStreamsInput() == null) ? 0 : kinesisStreamsInput().hashCode());
        hashCode = 31 * hashCode + ((kinesisFirehoseInput() == null) ? 0 : kinesisFirehoseInput().hashCode());
        hashCode = 31 * hashCode + ((inputParallelism() == null) ? 0 : inputParallelism().hashCode());
        hashCode = 31 * hashCode + ((inputSchema() == null) ? 0 : inputSchema().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Input)) {
            return false;
        }
        Input other = (Input) obj;
        if (other.namePrefix() == null ^ this.namePrefix() == null) {
            return false;
        }
        if (other.namePrefix() != null && !other.namePrefix().equals(this.namePrefix())) {
            return false;
        }
        if (other.kinesisStreamsInput() == null ^ this.kinesisStreamsInput() == null) {
            return false;
        }
        if (other.kinesisStreamsInput() != null && !other.kinesisStreamsInput().equals(this.kinesisStreamsInput())) {
            return false;
        }
        if (other.kinesisFirehoseInput() == null ^ this.kinesisFirehoseInput() == null) {
            return false;
        }
        if (other.kinesisFirehoseInput() != null && !other.kinesisFirehoseInput().equals(this.kinesisFirehoseInput())) {
            return false;
        }
        if (other.inputParallelism() == null ^ this.inputParallelism() == null) {
            return false;
        }
        if (other.inputParallelism() != null && !other.inputParallelism().equals(this.inputParallelism())) {
            return false;
        }
        if (other.inputSchema() == null ^ this.inputSchema() == null) {
            return false;
        }
        if (other.inputSchema() != null && !other.inputSchema().equals(this.inputSchema())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (namePrefix() != null) {
            sb.append("NamePrefix: ").append(namePrefix()).append(",");
        }
        if (kinesisStreamsInput() != null) {
            sb.append("KinesisStreamsInput: ").append(kinesisStreamsInput()).append(",");
        }
        if (kinesisFirehoseInput() != null) {
            sb.append("KinesisFirehoseInput: ").append(kinesisFirehoseInput()).append(",");
        }
        if (inputParallelism() != null) {
            sb.append("InputParallelism: ").append(inputParallelism()).append(",");
        }
        if (inputSchema() != null) {
            sb.append("InputSchema: ").append(inputSchema()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NamePrefix":
            return Optional.of(clazz.cast(namePrefix()));
        case "KinesisStreamsInput":
            return Optional.of(clazz.cast(kinesisStreamsInput()));
        case "KinesisFirehoseInput":
            return Optional.of(clazz.cast(kinesisFirehoseInput()));
        case "InputParallelism":
            return Optional.of(clazz.cast(inputParallelism()));
        case "InputSchema":
            return Optional.of(clazz.cast(inputSchema()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Input> {
        /**
         * <p>
         * Name prefix to use when creating in-application stream. Suppose you specify a prefix "MyInApplicationStream".
         * Amazon Kinesis Analytics will then create one or more (as per the <code>InputParallelism</code> count you
         * specified) in-application streams with names "MyInApplicationStream_001", "MyInApplicationStream_002" and so
         * on.
         * </p>
         * 
         * @param namePrefix
         *        Name prefix to use when creating in-application stream. Suppose you specify a prefix
         *        "MyInApplicationStream". Amazon Kinesis Analytics will then create one or more (as per the
         *        <code>InputParallelism</code> count you specified) in-application streams with names
         *        "MyInApplicationStream_001", "MyInApplicationStream_002" and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namePrefix(String namePrefix);

        /**
         * <p>
         * If the streaming source is an Amazon Kinesis stream, identifies the stream's Amazon Resource Name (ARN) and
         * an IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.
         * </p>
         * 
         * @param kinesisStreamsInput
         *        If the streaming source is an Amazon Kinesis stream, identifies the stream's Amazon Resource Name
         *        (ARN) and an IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamsInput(KinesisStreamsInput kinesisStreamsInput);

        /**
         * <p>
         * If the streaming source is an Amazon Kinesis Firehose delivery stream, identifies the Firehose delivery
         * stream's ARN and an IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.
         * </p>
         * 
         * @param kinesisFirehoseInput
         *        If the streaming source is an Amazon Kinesis Firehose delivery stream, identifies the Firehose
         *        delivery stream's ARN and an IAM role that enables Amazon Kinesis Analytics to access the stream on
         *        your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisFirehoseInput(KinesisFirehoseInput kinesisFirehoseInput);

        /**
         * <p>
         * Describes the number of in-application streams to create.
         * </p>
         * <p>
         * Data from your source will be routed to these in-application input streams.
         * </p>
         * <p>
         * (see <a href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring
         * Application Input</a>.
         * </p>
         * 
         * @param inputParallelism
         *        Describes the number of in-application streams to create. </p>
         *        <p>
         *        Data from your source will be routed to these in-application input streams.
         *        </p>
         *        <p>
         *        (see <a
         *        href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring
         *        Application Input</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputParallelism(InputParallelism inputParallelism);

        /**
         * <p>
         * Describes the format of the data in the streaming source, and how each data element maps to corresponding
         * columns in the in-application stream that is being created.
         * </p>
         * <p>
         * Also used to describe the format of the reference data source.
         * </p>
         * 
         * @param inputSchema
         *        Describes the format of the data in the streaming source, and how each data element maps to
         *        corresponding columns in the in-application stream that is being created.</p>
         *        <p>
         *        Also used to describe the format of the reference data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSchema(SourceSchema inputSchema);
    }

    static final class BuilderImpl implements Builder {
        private String namePrefix;

        private KinesisStreamsInput kinesisStreamsInput;

        private KinesisFirehoseInput kinesisFirehoseInput;

        private InputParallelism inputParallelism;

        private SourceSchema inputSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(Input model) {
            namePrefix(model.namePrefix);
            kinesisStreamsInput(model.kinesisStreamsInput);
            kinesisFirehoseInput(model.kinesisFirehoseInput);
            inputParallelism(model.inputParallelism);
            inputSchema(model.inputSchema);
        }

        public final String getNamePrefix() {
            return namePrefix;
        }

        @Override
        public final Builder namePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
            return this;
        }

        public final void setNamePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        public final KinesisStreamsInput.Builder getKinesisStreamsInput() {
            return kinesisStreamsInput != null ? kinesisStreamsInput.toBuilder() : null;
        }

        @Override
        public final Builder kinesisStreamsInput(KinesisStreamsInput kinesisStreamsInput) {
            this.kinesisStreamsInput = kinesisStreamsInput;
            return this;
        }

        public final void setKinesisStreamsInput(KinesisStreamsInput.BuilderImpl kinesisStreamsInput) {
            this.kinesisStreamsInput = kinesisStreamsInput != null ? kinesisStreamsInput.build() : null;
        }

        public final KinesisFirehoseInput.Builder getKinesisFirehoseInput() {
            return kinesisFirehoseInput != null ? kinesisFirehoseInput.toBuilder() : null;
        }

        @Override
        public final Builder kinesisFirehoseInput(KinesisFirehoseInput kinesisFirehoseInput) {
            this.kinesisFirehoseInput = kinesisFirehoseInput;
            return this;
        }

        public final void setKinesisFirehoseInput(KinesisFirehoseInput.BuilderImpl kinesisFirehoseInput) {
            this.kinesisFirehoseInput = kinesisFirehoseInput != null ? kinesisFirehoseInput.build() : null;
        }

        public final InputParallelism.Builder getInputParallelism() {
            return inputParallelism != null ? inputParallelism.toBuilder() : null;
        }

        @Override
        public final Builder inputParallelism(InputParallelism inputParallelism) {
            this.inputParallelism = inputParallelism;
            return this;
        }

        public final void setInputParallelism(InputParallelism.BuilderImpl inputParallelism) {
            this.inputParallelism = inputParallelism != null ? inputParallelism.build() : null;
        }

        public final SourceSchema.Builder getInputSchema() {
            return inputSchema != null ? inputSchema.toBuilder() : null;
        }

        @Override
        public final Builder inputSchema(SourceSchema inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        public final void setInputSchema(SourceSchema.BuilderImpl inputSchema) {
            this.inputSchema = inputSchema != null ? inputSchema.build() : null;
        }

        @Override
        public Input build() {
            return new Input(this);
        }
    }
}
