/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesis.transform.ShardMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A uniquely identified group of data records in an Amazon Kinesis stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Shard implements StructuredPojo, ToCopyableBuilder<Shard.Builder, Shard> {
    private final String shardId;

    private final String parentShardId;

    private final String adjacentParentShardId;

    private final HashKeyRange hashKeyRange;

    private final SequenceNumberRange sequenceNumberRange;

    private Shard(BuilderImpl builder) {
        this.shardId = builder.shardId;
        this.parentShardId = builder.parentShardId;
        this.adjacentParentShardId = builder.adjacentParentShardId;
        this.hashKeyRange = builder.hashKeyRange;
        this.sequenceNumberRange = builder.sequenceNumberRange;
    }

    /**
     * <p>
     * The unique identifier of the shard within the stream.
     * </p>
     * 
     * @return The unique identifier of the shard within the stream.
     */
    public String shardId() {
        return shardId;
    }

    /**
     * <p>
     * The shard ID of the shard's parent.
     * </p>
     * 
     * @return The shard ID of the shard's parent.
     */
    public String parentShardId() {
        return parentShardId;
    }

    /**
     * <p>
     * The shard ID of the shard adjacent to the shard's parent.
     * </p>
     * 
     * @return The shard ID of the shard adjacent to the shard's parent.
     */
    public String adjacentParentShardId() {
        return adjacentParentShardId;
    }

    /**
     * <p>
     * The range of possible hash key values for the shard, which is a set of ordered contiguous positive integers.
     * </p>
     * 
     * @return The range of possible hash key values for the shard, which is a set of ordered contiguous positive
     *         integers.
     */
    public HashKeyRange hashKeyRange() {
        return hashKeyRange;
    }

    /**
     * <p>
     * The range of possible sequence numbers for the shard.
     * </p>
     * 
     * @return The range of possible sequence numbers for the shard.
     */
    public SequenceNumberRange sequenceNumberRange() {
        return sequenceNumberRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((shardId() == null) ? 0 : shardId().hashCode());
        hashCode = 31 * hashCode + ((parentShardId() == null) ? 0 : parentShardId().hashCode());
        hashCode = 31 * hashCode + ((adjacentParentShardId() == null) ? 0 : adjacentParentShardId().hashCode());
        hashCode = 31 * hashCode + ((hashKeyRange() == null) ? 0 : hashKeyRange().hashCode());
        hashCode = 31 * hashCode + ((sequenceNumberRange() == null) ? 0 : sequenceNumberRange().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Shard)) {
            return false;
        }
        Shard other = (Shard) obj;
        if (other.shardId() == null ^ this.shardId() == null) {
            return false;
        }
        if (other.shardId() != null && !other.shardId().equals(this.shardId())) {
            return false;
        }
        if (other.parentShardId() == null ^ this.parentShardId() == null) {
            return false;
        }
        if (other.parentShardId() != null && !other.parentShardId().equals(this.parentShardId())) {
            return false;
        }
        if (other.adjacentParentShardId() == null ^ this.adjacentParentShardId() == null) {
            return false;
        }
        if (other.adjacentParentShardId() != null && !other.adjacentParentShardId().equals(this.adjacentParentShardId())) {
            return false;
        }
        if (other.hashKeyRange() == null ^ this.hashKeyRange() == null) {
            return false;
        }
        if (other.hashKeyRange() != null && !other.hashKeyRange().equals(this.hashKeyRange())) {
            return false;
        }
        if (other.sequenceNumberRange() == null ^ this.sequenceNumberRange() == null) {
            return false;
        }
        if (other.sequenceNumberRange() != null && !other.sequenceNumberRange().equals(this.sequenceNumberRange())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (shardId() != null) {
            sb.append("ShardId: ").append(shardId()).append(",");
        }
        if (parentShardId() != null) {
            sb.append("ParentShardId: ").append(parentShardId()).append(",");
        }
        if (adjacentParentShardId() != null) {
            sb.append("AdjacentParentShardId: ").append(adjacentParentShardId()).append(",");
        }
        if (hashKeyRange() != null) {
            sb.append("HashKeyRange: ").append(hashKeyRange()).append(",");
        }
        if (sequenceNumberRange() != null) {
            sb.append("SequenceNumberRange: ").append(sequenceNumberRange()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShardId":
            return Optional.of(clazz.cast(shardId()));
        case "ParentShardId":
            return Optional.of(clazz.cast(parentShardId()));
        case "AdjacentParentShardId":
            return Optional.of(clazz.cast(adjacentParentShardId()));
        case "HashKeyRange":
            return Optional.of(clazz.cast(hashKeyRange()));
        case "SequenceNumberRange":
            return Optional.of(clazz.cast(sequenceNumberRange()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ShardMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Shard> {
        /**
         * <p>
         * The unique identifier of the shard within the stream.
         * </p>
         * 
         * @param shardId
         *        The unique identifier of the shard within the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardId(String shardId);

        /**
         * <p>
         * The shard ID of the shard's parent.
         * </p>
         * 
         * @param parentShardId
         *        The shard ID of the shard's parent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentShardId(String parentShardId);

        /**
         * <p>
         * The shard ID of the shard adjacent to the shard's parent.
         * </p>
         * 
         * @param adjacentParentShardId
         *        The shard ID of the shard adjacent to the shard's parent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adjacentParentShardId(String adjacentParentShardId);

        /**
         * <p>
         * The range of possible hash key values for the shard, which is a set of ordered contiguous positive integers.
         * </p>
         * 
         * @param hashKeyRange
         *        The range of possible hash key values for the shard, which is a set of ordered contiguous positive
         *        integers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hashKeyRange(HashKeyRange hashKeyRange);

        /**
         * <p>
         * The range of possible sequence numbers for the shard.
         * </p>
         * 
         * @param sequenceNumberRange
         *        The range of possible sequence numbers for the shard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceNumberRange(SequenceNumberRange sequenceNumberRange);
    }

    static final class BuilderImpl implements Builder {
        private String shardId;

        private String parentShardId;

        private String adjacentParentShardId;

        private HashKeyRange hashKeyRange;

        private SequenceNumberRange sequenceNumberRange;

        private BuilderImpl() {
        }

        private BuilderImpl(Shard model) {
            shardId(model.shardId);
            parentShardId(model.parentShardId);
            adjacentParentShardId(model.adjacentParentShardId);
            hashKeyRange(model.hashKeyRange);
            sequenceNumberRange(model.sequenceNumberRange);
        }

        public final String getShardId() {
            return shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        public final String getParentShardId() {
            return parentShardId;
        }

        @Override
        public final Builder parentShardId(String parentShardId) {
            this.parentShardId = parentShardId;
            return this;
        }

        public final void setParentShardId(String parentShardId) {
            this.parentShardId = parentShardId;
        }

        public final String getAdjacentParentShardId() {
            return adjacentParentShardId;
        }

        @Override
        public final Builder adjacentParentShardId(String adjacentParentShardId) {
            this.adjacentParentShardId = adjacentParentShardId;
            return this;
        }

        public final void setAdjacentParentShardId(String adjacentParentShardId) {
            this.adjacentParentShardId = adjacentParentShardId;
        }

        public final HashKeyRange.Builder getHashKeyRange() {
            return hashKeyRange != null ? hashKeyRange.toBuilder() : null;
        }

        @Override
        public final Builder hashKeyRange(HashKeyRange hashKeyRange) {
            this.hashKeyRange = hashKeyRange;
            return this;
        }

        public final void setHashKeyRange(HashKeyRange.BuilderImpl hashKeyRange) {
            this.hashKeyRange = hashKeyRange != null ? hashKeyRange.build() : null;
        }

        public final SequenceNumberRange.Builder getSequenceNumberRange() {
            return sequenceNumberRange != null ? sequenceNumberRange.toBuilder() : null;
        }

        @Override
        public final Builder sequenceNumberRange(SequenceNumberRange sequenceNumberRange) {
            this.sequenceNumberRange = sequenceNumberRange;
            return this;
        }

        public final void setSequenceNumberRange(SequenceNumberRange.BuilderImpl sequenceNumberRange) {
            this.sequenceNumberRange = sequenceNumberRange != null ? sequenceNumberRange.build() : null;
        }

        @Override
        public Shard build() {
            return new Shard(this);
        }
    }
}
