/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <code>PutRecords</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PutRecordsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutRecordsRequest.Builder, PutRecordsRequest> {
    private final List<PutRecordsRequestEntry> records;

    private final String streamName;

    private PutRecordsRequest(BuilderImpl builder) {
        this.records = builder.records;
        this.streamName = builder.streamName;
    }

    /**
     * <p>
     * The records associated with the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The records associated with the request.
     */
    public List<PutRecordsRequestEntry> records() {
        return records;
    }

    /**
     * <p>
     * The stream name associated with the request.
     * </p>
     * 
     * @return The stream name associated with the request.
     */
    public String streamName() {
        return streamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((records() == null) ? 0 : records().hashCode());
        hashCode = 31 * hashCode + ((streamName() == null) ? 0 : streamName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordsRequest)) {
            return false;
        }
        PutRecordsRequest other = (PutRecordsRequest) obj;
        if (other.records() == null ^ this.records() == null) {
            return false;
        }
        if (other.records() != null && !other.records().equals(this.records())) {
            return false;
        }
        if (other.streamName() == null ^ this.streamName() == null) {
            return false;
        }
        if (other.streamName() != null && !other.streamName().equals(this.streamName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (records() != null) {
            sb.append("Records: ").append(records()).append(",");
        }
        if (streamName() != null) {
            sb.append("StreamName: ").append(streamName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Records":
            return Optional.of(clazz.cast(records()));
        case "StreamName":
            return Optional.of(clazz.cast(streamName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, PutRecordsRequest> {
        /**
         * <p>
         * The records associated with the request.
         * </p>
         * 
         * @param records
         *        The records associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<PutRecordsRequestEntry> records);

        /**
         * <p>
         * The records associated with the request.
         * </p>
         * 
         * @param records
         *        The records associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(PutRecordsRequestEntry... records);

        /**
         * <p>
         * The stream name associated with the request.
         * </p>
         * 
         * @param streamName
         *        The stream name associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);
    }

    static final class BuilderImpl implements Builder {
        private List<PutRecordsRequestEntry> records;

        private String streamName;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordsRequest model) {
            records(model.records);
            streamName(model.streamName);
        }

        public final Collection<PutRecordsRequestEntry.Builder> getRecords() {
            return records != null ? records.stream().map(PutRecordsRequestEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder records(Collection<PutRecordsRequestEntry> records) {
            this.records = PutRecordsRequestEntryListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(PutRecordsRequestEntry... records) {
            records(Arrays.asList(records));
            return this;
        }

        public final void setRecords(Collection<PutRecordsRequestEntry.BuilderImpl> records) {
            this.records = PutRecordsRequestEntryListCopier.copyFromBuilder(records);
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public PutRecordsRequest build() {
            return new PutRecordsRequest(this);
        }
    }
}
