/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.firehose.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DeliveryStreamDescription JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DeliveryStreamDescriptionUnmarshaller implements Unmarshaller<DeliveryStreamDescription, JsonUnmarshallerContext> {

    public DeliveryStreamDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        DeliveryStreamDescription.Builder deliveryStreamDescriptionBuilder = DeliveryStreamDescription.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("DeliveryStreamName", targetDepth)) {
                    context.nextToken();
                    deliveryStreamDescriptionBuilder
                            .deliveryStreamName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DeliveryStreamARN", targetDepth)) {
                    context.nextToken();
                    deliveryStreamDescriptionBuilder.deliveryStreamARN(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DeliveryStreamStatus", targetDepth)) {
                    context.nextToken();
                    deliveryStreamDescriptionBuilder.deliveryStreamStatus(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("VersionId", targetDepth)) {
                    context.nextToken();
                    deliveryStreamDescriptionBuilder.versionId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreateTimestamp", targetDepth)) {
                    context.nextToken();
                    deliveryStreamDescriptionBuilder.createTimestamp(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("LastUpdateTimestamp", targetDepth)) {
                    context.nextToken();
                    deliveryStreamDescriptionBuilder.lastUpdateTimestamp(context.getUnmarshaller(java.time.Instant.class)
                            .unmarshall(context));
                }
                if (context.testExpression("Destinations", targetDepth)) {
                    context.nextToken();
                    deliveryStreamDescriptionBuilder.destinations(new ListUnmarshaller<DestinationDescription>(
                            DestinationDescriptionUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("HasMoreDestinations", targetDepth)) {
                    context.nextToken();
                    deliveryStreamDescriptionBuilder.hasMoreDestinations(context.getUnmarshaller(Boolean.class).unmarshall(
                            context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return deliveryStreamDescriptionBuilder.build();
    }

    private static final DeliveryStreamDescriptionUnmarshaller INSTANCE = new DeliveryStreamDescriptionUnmarshaller();

    public static DeliveryStreamDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}
