/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateDestinationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateDestinationRequest.Builder, UpdateDestinationRequest> {
    private final String deliveryStreamName;

    private final String currentDeliveryStreamVersionId;

    private final String destinationId;

    private final S3DestinationUpdate s3DestinationUpdate;

    private final ExtendedS3DestinationUpdate extendedS3DestinationUpdate;

    private final RedshiftDestinationUpdate redshiftDestinationUpdate;

    private final ElasticsearchDestinationUpdate elasticsearchDestinationUpdate;

    private UpdateDestinationRequest(BuilderImpl builder) {
        this.deliveryStreamName = builder.deliveryStreamName;
        this.currentDeliveryStreamVersionId = builder.currentDeliveryStreamVersionId;
        this.destinationId = builder.destinationId;
        this.s3DestinationUpdate = builder.s3DestinationUpdate;
        this.extendedS3DestinationUpdate = builder.extendedS3DestinationUpdate;
        this.redshiftDestinationUpdate = builder.redshiftDestinationUpdate;
        this.elasticsearchDestinationUpdate = builder.elasticsearchDestinationUpdate;
    }

    /**
     * <p>
     * The name of the delivery stream.
     * </p>
     * 
     * @return The name of the delivery stream.
     */
    public String deliveryStreamName() {
        return deliveryStreamName;
    }

    /**
     * <p>
     * Obtain this value from the <b>VersionId</b> result of <a>DeliveryStreamDescription</a>. This value is required,
     * and helps the service to perform conditional operations. For example, if there is a interleaving update and this
     * value is null, then the update destination fails. After the update is successful, the <b>VersionId</b> value is
     * updated. The service then performs a merge of the old configuration with the new configuration.
     * </p>
     * 
     * @return Obtain this value from the <b>VersionId</b> result of <a>DeliveryStreamDescription</a>. This value is
     *         required, and helps the service to perform conditional operations. For example, if there is a
     *         interleaving update and this value is null, then the update destination fails. After the update is
     *         successful, the <b>VersionId</b> value is updated. The service then performs a merge of the old
     *         configuration with the new configuration.
     */
    public String currentDeliveryStreamVersionId() {
        return currentDeliveryStreamVersionId;
    }

    /**
     * <p>
     * The ID of the destination.
     * </p>
     * 
     * @return The ID of the destination.
     */
    public String destinationId() {
        return destinationId;
    }

    /**
     * <p>
     * [Deprecated] Describes an update for a destination in Amazon S3.
     * </p>
     * 
     * @return [Deprecated] Describes an update for a destination in Amazon S3.
     */
    public S3DestinationUpdate s3DestinationUpdate() {
        return s3DestinationUpdate;
    }

    /**
     * <p>
     * Describes an update for a destination in Amazon S3.
     * </p>
     * 
     * @return Describes an update for a destination in Amazon S3.
     */
    public ExtendedS3DestinationUpdate extendedS3DestinationUpdate() {
        return extendedS3DestinationUpdate;
    }

    /**
     * <p>
     * Describes an update for a destination in Amazon Redshift.
     * </p>
     * 
     * @return Describes an update for a destination in Amazon Redshift.
     */
    public RedshiftDestinationUpdate redshiftDestinationUpdate() {
        return redshiftDestinationUpdate;
    }

    /**
     * <p>
     * Describes an update for a destination in Amazon ES.
     * </p>
     * 
     * @return Describes an update for a destination in Amazon ES.
     */
    public ElasticsearchDestinationUpdate elasticsearchDestinationUpdate() {
        return elasticsearchDestinationUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deliveryStreamName() == null) ? 0 : deliveryStreamName().hashCode());
        hashCode = 31 * hashCode + ((currentDeliveryStreamVersionId() == null) ? 0 : currentDeliveryStreamVersionId().hashCode());
        hashCode = 31 * hashCode + ((destinationId() == null) ? 0 : destinationId().hashCode());
        hashCode = 31 * hashCode + ((s3DestinationUpdate() == null) ? 0 : s3DestinationUpdate().hashCode());
        hashCode = 31 * hashCode + ((extendedS3DestinationUpdate() == null) ? 0 : extendedS3DestinationUpdate().hashCode());
        hashCode = 31 * hashCode + ((redshiftDestinationUpdate() == null) ? 0 : redshiftDestinationUpdate().hashCode());
        hashCode = 31 * hashCode + ((elasticsearchDestinationUpdate() == null) ? 0 : elasticsearchDestinationUpdate().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDestinationRequest)) {
            return false;
        }
        UpdateDestinationRequest other = (UpdateDestinationRequest) obj;
        if (other.deliveryStreamName() == null ^ this.deliveryStreamName() == null) {
            return false;
        }
        if (other.deliveryStreamName() != null && !other.deliveryStreamName().equals(this.deliveryStreamName())) {
            return false;
        }
        if (other.currentDeliveryStreamVersionId() == null ^ this.currentDeliveryStreamVersionId() == null) {
            return false;
        }
        if (other.currentDeliveryStreamVersionId() != null
                && !other.currentDeliveryStreamVersionId().equals(this.currentDeliveryStreamVersionId())) {
            return false;
        }
        if (other.destinationId() == null ^ this.destinationId() == null) {
            return false;
        }
        if (other.destinationId() != null && !other.destinationId().equals(this.destinationId())) {
            return false;
        }
        if (other.s3DestinationUpdate() == null ^ this.s3DestinationUpdate() == null) {
            return false;
        }
        if (other.s3DestinationUpdate() != null && !other.s3DestinationUpdate().equals(this.s3DestinationUpdate())) {
            return false;
        }
        if (other.extendedS3DestinationUpdate() == null ^ this.extendedS3DestinationUpdate() == null) {
            return false;
        }
        if (other.extendedS3DestinationUpdate() != null
                && !other.extendedS3DestinationUpdate().equals(this.extendedS3DestinationUpdate())) {
            return false;
        }
        if (other.redshiftDestinationUpdate() == null ^ this.redshiftDestinationUpdate() == null) {
            return false;
        }
        if (other.redshiftDestinationUpdate() != null
                && !other.redshiftDestinationUpdate().equals(this.redshiftDestinationUpdate())) {
            return false;
        }
        if (other.elasticsearchDestinationUpdate() == null ^ this.elasticsearchDestinationUpdate() == null) {
            return false;
        }
        if (other.elasticsearchDestinationUpdate() != null
                && !other.elasticsearchDestinationUpdate().equals(this.elasticsearchDestinationUpdate())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (deliveryStreamName() != null) {
            sb.append("DeliveryStreamName: ").append(deliveryStreamName()).append(",");
        }
        if (currentDeliveryStreamVersionId() != null) {
            sb.append("CurrentDeliveryStreamVersionId: ").append(currentDeliveryStreamVersionId()).append(",");
        }
        if (destinationId() != null) {
            sb.append("DestinationId: ").append(destinationId()).append(",");
        }
        if (s3DestinationUpdate() != null) {
            sb.append("S3DestinationUpdate: ").append(s3DestinationUpdate()).append(",");
        }
        if (extendedS3DestinationUpdate() != null) {
            sb.append("ExtendedS3DestinationUpdate: ").append(extendedS3DestinationUpdate()).append(",");
        }
        if (redshiftDestinationUpdate() != null) {
            sb.append("RedshiftDestinationUpdate: ").append(redshiftDestinationUpdate()).append(",");
        }
        if (elasticsearchDestinationUpdate() != null) {
            sb.append("ElasticsearchDestinationUpdate: ").append(elasticsearchDestinationUpdate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryStreamName":
            return Optional.of(clazz.cast(deliveryStreamName()));
        case "CurrentDeliveryStreamVersionId":
            return Optional.of(clazz.cast(currentDeliveryStreamVersionId()));
        case "DestinationId":
            return Optional.of(clazz.cast(destinationId()));
        case "S3DestinationUpdate":
            return Optional.of(clazz.cast(s3DestinationUpdate()));
        case "ExtendedS3DestinationUpdate":
            return Optional.of(clazz.cast(extendedS3DestinationUpdate()));
        case "RedshiftDestinationUpdate":
            return Optional.of(clazz.cast(redshiftDestinationUpdate()));
        case "ElasticsearchDestinationUpdate":
            return Optional.of(clazz.cast(elasticsearchDestinationUpdate()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateDestinationRequest> {
        /**
         * <p>
         * The name of the delivery stream.
         * </p>
         * 
         * @param deliveryStreamName
         *        The name of the delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamName(String deliveryStreamName);

        /**
         * <p>
         * Obtain this value from the <b>VersionId</b> result of <a>DeliveryStreamDescription</a>. This value is
         * required, and helps the service to perform conditional operations. For example, if there is a interleaving
         * update and this value is null, then the update destination fails. After the update is successful, the
         * <b>VersionId</b> value is updated. The service then performs a merge of the old configuration with the new
         * configuration.
         * </p>
         * 
         * @param currentDeliveryStreamVersionId
         *        Obtain this value from the <b>VersionId</b> result of <a>DeliveryStreamDescription</a>. This value is
         *        required, and helps the service to perform conditional operations. For example, if there is a
         *        interleaving update and this value is null, then the update destination fails. After the update is
         *        successful, the <b>VersionId</b> value is updated. The service then performs a merge of the old
         *        configuration with the new configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentDeliveryStreamVersionId(String currentDeliveryStreamVersionId);

        /**
         * <p>
         * The ID of the destination.
         * </p>
         * 
         * @param destinationId
         *        The ID of the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationId(String destinationId);

        /**
         * <p>
         * [Deprecated] Describes an update for a destination in Amazon S3.
         * </p>
         * 
         * @param s3DestinationUpdate
         *        [Deprecated] Describes an update for a destination in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DestinationUpdate(S3DestinationUpdate s3DestinationUpdate);

        /**
         * <p>
         * Describes an update for a destination in Amazon S3.
         * </p>
         * 
         * @param extendedS3DestinationUpdate
         *        Describes an update for a destination in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendedS3DestinationUpdate(ExtendedS3DestinationUpdate extendedS3DestinationUpdate);

        /**
         * <p>
         * Describes an update for a destination in Amazon Redshift.
         * </p>
         * 
         * @param redshiftDestinationUpdate
         *        Describes an update for a destination in Amazon Redshift.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftDestinationUpdate(RedshiftDestinationUpdate redshiftDestinationUpdate);

        /**
         * <p>
         * Describes an update for a destination in Amazon ES.
         * </p>
         * 
         * @param elasticsearchDestinationUpdate
         *        Describes an update for a destination in Amazon ES.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticsearchDestinationUpdate(ElasticsearchDestinationUpdate elasticsearchDestinationUpdate);
    }

    static final class BuilderImpl implements Builder {
        private String deliveryStreamName;

        private String currentDeliveryStreamVersionId;

        private String destinationId;

        private S3DestinationUpdate s3DestinationUpdate;

        private ExtendedS3DestinationUpdate extendedS3DestinationUpdate;

        private RedshiftDestinationUpdate redshiftDestinationUpdate;

        private ElasticsearchDestinationUpdate elasticsearchDestinationUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDestinationRequest model) {
            deliveryStreamName(model.deliveryStreamName);
            currentDeliveryStreamVersionId(model.currentDeliveryStreamVersionId);
            destinationId(model.destinationId);
            s3DestinationUpdate(model.s3DestinationUpdate);
            extendedS3DestinationUpdate(model.extendedS3DestinationUpdate);
            redshiftDestinationUpdate(model.redshiftDestinationUpdate);
            elasticsearchDestinationUpdate(model.elasticsearchDestinationUpdate);
        }

        public final String getDeliveryStreamName() {
            return deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        public final String getCurrentDeliveryStreamVersionId() {
            return currentDeliveryStreamVersionId;
        }

        @Override
        public final Builder currentDeliveryStreamVersionId(String currentDeliveryStreamVersionId) {
            this.currentDeliveryStreamVersionId = currentDeliveryStreamVersionId;
            return this;
        }

        public final void setCurrentDeliveryStreamVersionId(String currentDeliveryStreamVersionId) {
            this.currentDeliveryStreamVersionId = currentDeliveryStreamVersionId;
        }

        public final String getDestinationId() {
            return destinationId;
        }

        @Override
        public final Builder destinationId(String destinationId) {
            this.destinationId = destinationId;
            return this;
        }

        public final void setDestinationId(String destinationId) {
            this.destinationId = destinationId;
        }

        public final S3DestinationUpdate.Builder getS3DestinationUpdate() {
            return s3DestinationUpdate != null ? s3DestinationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder s3DestinationUpdate(S3DestinationUpdate s3DestinationUpdate) {
            this.s3DestinationUpdate = s3DestinationUpdate;
            return this;
        }

        public final void setS3DestinationUpdate(S3DestinationUpdate.BuilderImpl s3DestinationUpdate) {
            this.s3DestinationUpdate = s3DestinationUpdate != null ? s3DestinationUpdate.build() : null;
        }

        public final ExtendedS3DestinationUpdate.Builder getExtendedS3DestinationUpdate() {
            return extendedS3DestinationUpdate != null ? extendedS3DestinationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder extendedS3DestinationUpdate(ExtendedS3DestinationUpdate extendedS3DestinationUpdate) {
            this.extendedS3DestinationUpdate = extendedS3DestinationUpdate;
            return this;
        }

        public final void setExtendedS3DestinationUpdate(ExtendedS3DestinationUpdate.BuilderImpl extendedS3DestinationUpdate) {
            this.extendedS3DestinationUpdate = extendedS3DestinationUpdate != null ? extendedS3DestinationUpdate.build() : null;
        }

        public final RedshiftDestinationUpdate.Builder getRedshiftDestinationUpdate() {
            return redshiftDestinationUpdate != null ? redshiftDestinationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder redshiftDestinationUpdate(RedshiftDestinationUpdate redshiftDestinationUpdate) {
            this.redshiftDestinationUpdate = redshiftDestinationUpdate;
            return this;
        }

        public final void setRedshiftDestinationUpdate(RedshiftDestinationUpdate.BuilderImpl redshiftDestinationUpdate) {
            this.redshiftDestinationUpdate = redshiftDestinationUpdate != null ? redshiftDestinationUpdate.build() : null;
        }

        public final ElasticsearchDestinationUpdate.Builder getElasticsearchDestinationUpdate() {
            return elasticsearchDestinationUpdate != null ? elasticsearchDestinationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearchDestinationUpdate(ElasticsearchDestinationUpdate elasticsearchDestinationUpdate) {
            this.elasticsearchDestinationUpdate = elasticsearchDestinationUpdate;
            return this;
        }

        public final void setElasticsearchDestinationUpdate(
                ElasticsearchDestinationUpdate.BuilderImpl elasticsearchDestinationUpdate) {
            this.elasticsearchDestinationUpdate = elasticsearchDestinationUpdate != null ? elasticsearchDestinationUpdate.build()
                    : null;
        }

        @Override
        public UpdateDestinationRequest build() {
            return new UpdateDestinationRequest(this);
        }
    }
}
