/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutRecordResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<PutRecordResponse.Builder, PutRecordResponse> {
    private final String recordId;

    private PutRecordResponse(BuilderImpl builder) {
        this.recordId = builder.recordId;
    }

    /**
     * <p>
     * The ID of the record.
     * </p>
     * 
     * @return The ID of the record.
     */
    public String recordId() {
        return recordId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((recordId() == null) ? 0 : recordId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordResponse)) {
            return false;
        }
        PutRecordResponse other = (PutRecordResponse) obj;
        if (other.recordId() == null ^ this.recordId() == null) {
            return false;
        }
        if (other.recordId() != null && !other.recordId().equals(this.recordId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (recordId() != null) {
            sb.append("RecordId: ").append(recordId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecordId":
            return Optional.of(clazz.cast(recordId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, PutRecordResponse> {
        /**
         * <p>
         * The ID of the record.
         * </p>
         * 
         * @param recordId
         *        The ID of the record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordId(String recordId);
    }

    static final class BuilderImpl implements Builder {
        private String recordId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordResponse model) {
            recordId(model.recordId);
        }

        public final String getRecordId() {
            return recordId;
        }

        @Override
        public final Builder recordId(String recordId) {
            this.recordId = recordId;
            return this;
        }

        public final void setRecordId(String recordId) {
            this.recordId = recordId;
        }

        @Override
        public PutRecordResponse build() {
            return new PutRecordResponse(this);
        }
    }
}
