/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListDeliveryStreamsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListDeliveryStreamsRequest.Builder, ListDeliveryStreamsRequest> {
    private final Integer limit;

    private final String exclusiveStartDeliveryStreamName;

    private ListDeliveryStreamsRequest(BuilderImpl builder) {
        this.limit = builder.limit;
        this.exclusiveStartDeliveryStreamName = builder.exclusiveStartDeliveryStreamName;
    }

    /**
     * <p>
     * The maximum number of delivery streams to list.
     * </p>
     * 
     * @return The maximum number of delivery streams to list.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The name of the delivery stream to start the list with.
     * </p>
     * 
     * @return The name of the delivery stream to start the list with.
     */
    public String exclusiveStartDeliveryStreamName() {
        return exclusiveStartDeliveryStreamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((limit() == null) ? 0 : limit().hashCode());
        hashCode = 31 * hashCode
                + ((exclusiveStartDeliveryStreamName() == null) ? 0 : exclusiveStartDeliveryStreamName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeliveryStreamsRequest)) {
            return false;
        }
        ListDeliveryStreamsRequest other = (ListDeliveryStreamsRequest) obj;
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.exclusiveStartDeliveryStreamName() == null ^ this.exclusiveStartDeliveryStreamName() == null) {
            return false;
        }
        if (other.exclusiveStartDeliveryStreamName() != null
                && !other.exclusiveStartDeliveryStreamName().equals(this.exclusiveStartDeliveryStreamName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (limit() != null) {
            sb.append("Limit: ").append(limit()).append(",");
        }
        if (exclusiveStartDeliveryStreamName() != null) {
            sb.append("ExclusiveStartDeliveryStreamName: ").append(exclusiveStartDeliveryStreamName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Limit":
            return Optional.of(clazz.cast(limit()));
        case "ExclusiveStartDeliveryStreamName":
            return Optional.of(clazz.cast(exclusiveStartDeliveryStreamName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListDeliveryStreamsRequest> {
        /**
         * <p>
         * The maximum number of delivery streams to list.
         * </p>
         * 
         * @param limit
         *        The maximum number of delivery streams to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The name of the delivery stream to start the list with.
         * </p>
         * 
         * @param exclusiveStartDeliveryStreamName
         *        The name of the delivery stream to start the list with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveStartDeliveryStreamName(String exclusiveStartDeliveryStreamName);
    }

    static final class BuilderImpl implements Builder {
        private Integer limit;

        private String exclusiveStartDeliveryStreamName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeliveryStreamsRequest model) {
            limit(model.limit);
            exclusiveStartDeliveryStreamName(model.exclusiveStartDeliveryStreamName);
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getExclusiveStartDeliveryStreamName() {
            return exclusiveStartDeliveryStreamName;
        }

        @Override
        public final Builder exclusiveStartDeliveryStreamName(String exclusiveStartDeliveryStreamName) {
            this.exclusiveStartDeliveryStreamName = exclusiveStartDeliveryStreamName;
            return this;
        }

        public final void setExclusiveStartDeliveryStreamName(String exclusiveStartDeliveryStreamName) {
            this.exclusiveStartDeliveryStreamName = exclusiveStartDeliveryStreamName;
        }

        @Override
        public ListDeliveryStreamsRequest build() {
            return new ListDeliveryStreamsRequest(this);
        }
    }
}
