/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.ElasticsearchDestinationConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of a destination in Amazon ES.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ElasticsearchDestinationConfiguration implements StructuredPojo,
        ToCopyableBuilder<ElasticsearchDestinationConfiguration.Builder, ElasticsearchDestinationConfiguration> {
    private final String roleARN;

    private final String domainARN;

    private final String indexName;

    private final String typeName;

    private final String indexRotationPeriod;

    private final ElasticsearchBufferingHints bufferingHints;

    private final ElasticsearchRetryOptions retryOptions;

    private final String s3BackupMode;

    private final S3DestinationConfiguration s3Configuration;

    private final ProcessingConfiguration processingConfiguration;

    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;

    private ElasticsearchDestinationConfiguration(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.domainARN = builder.domainARN;
        this.indexName = builder.indexName;
        this.typeName = builder.typeName;
        this.indexRotationPeriod = builder.indexRotationPeriod;
        this.bufferingHints = builder.bufferingHints;
        this.retryOptions = builder.retryOptions;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3Configuration = builder.s3Configuration;
        this.processingConfiguration = builder.processingConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
    }

    /**
     * <p>
     * The ARN of the IAM role to be assumed by Firehose for calling the Amazon ES Configuration API and for indexing
     * documents. For more information, see <a
     * href="http://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Amazon S3 Bucket
     * Access</a>.
     * </p>
     * 
     * @return The ARN of the IAM role to be assumed by Firehose for calling the Amazon ES Configuration API and for
     *         indexing documents. For more information, see <a
     *         href="http://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Amazon S3
     *         Bucket Access</a>.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The ARN of the Amazon ES domain. The IAM role must have permissions for <code>DescribeElasticsearchDomain</code>,
     * <code>DescribeElasticsearchDomains</code>, and <code>DescribeElasticsearchDomainConfig</code> after assuming the
     * role specified in <b>RoleARN</b>.
     * </p>
     * 
     * @return The ARN of the Amazon ES domain. The IAM role must have permissions for 
     *         <code>DescribeElasticsearchDomain</code>, <code>DescribeElasticsearchDomains</code>, and
     *         <code>DescribeElasticsearchDomainConfig</code> after assuming the role specified in <b>RoleARN</b>.
     */
    public String domainARN() {
        return domainARN;
    }

    /**
     * <p>
     * The Elasticsearch index name.
     * </p>
     * 
     * @return The Elasticsearch index name.
     */
    public String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The Elasticsearch type name.
     * </p>
     * 
     * @return The Elasticsearch type name.
     */
    public String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The Elasticsearch index rotation period. Index rotation appends a timestamp to the IndexName to facilitate
     * expiration of old data. For more information, see <a
     * href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation for
     * Amazon Elasticsearch Service Destination</a>. The default value is <code>OneDay</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #indexRotationPeriod} will return {@link ElasticsearchIndexRotationPeriod#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #indexRotationPeriodString}.
     * </p>
     * 
     * @return The Elasticsearch index rotation period. Index rotation appends a timestamp to the IndexName to
     *         facilitate expiration of old data. For more information, see <a
     *         href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation
     *         for Amazon Elasticsearch Service Destination</a>. The default value is <code>OneDay</code>.
     * @see ElasticsearchIndexRotationPeriod
     */
    public ElasticsearchIndexRotationPeriod indexRotationPeriod() {
        return ElasticsearchIndexRotationPeriod.fromValue(indexRotationPeriod);
    }

    /**
     * <p>
     * The Elasticsearch index rotation period. Index rotation appends a timestamp to the IndexName to facilitate
     * expiration of old data. For more information, see <a
     * href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation for
     * Amazon Elasticsearch Service Destination</a>. The default value is <code>OneDay</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #indexRotationPeriod} will return {@link ElasticsearchIndexRotationPeriod#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #indexRotationPeriodString}.
     * </p>
     * 
     * @return The Elasticsearch index rotation period. Index rotation appends a timestamp to the IndexName to
     *         facilitate expiration of old data. For more information, see <a
     *         href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation
     *         for Amazon Elasticsearch Service Destination</a>. The default value is <code>OneDay</code>.
     * @see ElasticsearchIndexRotationPeriod
     */
    public String indexRotationPeriodString() {
        return indexRotationPeriod;
    }

    /**
     * <p>
     * The buffering options. If no value is specified, the default values for <b>ElasticsearchBufferingHints</b> are
     * used.
     * </p>
     * 
     * @return The buffering options. If no value is specified, the default values for
     *         <b>ElasticsearchBufferingHints</b> are used.
     */
    public ElasticsearchBufferingHints bufferingHints() {
        return bufferingHints;
    }

    /**
     * <p>
     * The retry behavior in the event that Firehose is unable to deliver documents to Amazon ES. The default value is
     * 300 (5 minutes).
     * </p>
     * 
     * @return The retry behavior in the event that Firehose is unable to deliver documents to Amazon ES. The default
     *         value is 300 (5 minutes).
     */
    public ElasticsearchRetryOptions retryOptions() {
        return retryOptions;
    }

    /**
     * <p>
     * Defines how documents should be delivered to Amazon S3. When set to FailedDocumentsOnly, Firehose writes any
     * documents that could not be indexed to the configured Amazon S3 destination, with elasticsearch-failed/ appended
     * to the key prefix. When set to AllDocuments, Firehose delivers all incoming records to Amazon S3, and also writes
     * failed documents with elasticsearch-failed/ appended to the prefix. For more information, see <a
     * href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-s3-backup">Amazon S3 Backup for Amazon
     * Elasticsearch Service Destination</a>. Default value is FailedDocumentsOnly.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3BackupMode} will
     * return {@link ElasticsearchS3BackupMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #s3BackupModeString}.
     * </p>
     * 
     * @return Defines how documents should be delivered to Amazon S3. When set to FailedDocumentsOnly, Firehose writes
     *         any documents that could not be indexed to the configured Amazon S3 destination, with
     *         elasticsearch-failed/ appended to the key prefix. When set to AllDocuments, Firehose delivers all
     *         incoming records to Amazon S3, and also writes failed documents with elasticsearch-failed/ appended to
     *         the prefix. For more information, see <a
     *         href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-s3-backup">Amazon S3 Backup
     *         for Amazon Elasticsearch Service Destination</a>. Default value is FailedDocumentsOnly.
     * @see ElasticsearchS3BackupMode
     */
    public ElasticsearchS3BackupMode s3BackupMode() {
        return ElasticsearchS3BackupMode.fromValue(s3BackupMode);
    }

    /**
     * <p>
     * Defines how documents should be delivered to Amazon S3. When set to FailedDocumentsOnly, Firehose writes any
     * documents that could not be indexed to the configured Amazon S3 destination, with elasticsearch-failed/ appended
     * to the key prefix. When set to AllDocuments, Firehose delivers all incoming records to Amazon S3, and also writes
     * failed documents with elasticsearch-failed/ appended to the prefix. For more information, see <a
     * href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-s3-backup">Amazon S3 Backup for Amazon
     * Elasticsearch Service Destination</a>. Default value is FailedDocumentsOnly.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3BackupMode} will
     * return {@link ElasticsearchS3BackupMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #s3BackupModeString}.
     * </p>
     * 
     * @return Defines how documents should be delivered to Amazon S3. When set to FailedDocumentsOnly, Firehose writes
     *         any documents that could not be indexed to the configured Amazon S3 destination, with
     *         elasticsearch-failed/ appended to the key prefix. When set to AllDocuments, Firehose delivers all
     *         incoming records to Amazon S3, and also writes failed documents with elasticsearch-failed/ appended to
     *         the prefix. For more information, see <a
     *         href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-s3-backup">Amazon S3 Backup
     *         for Amazon Elasticsearch Service Destination</a>. Default value is FailedDocumentsOnly.
     * @see ElasticsearchS3BackupMode
     */
    public String s3BackupModeString() {
        return s3BackupMode;
    }

    /**
     * <p>
     * The configuration for the intermediate Amazon S3 location from which Amazon ES obtains data.
     * </p>
     * 
     * @return The configuration for the intermediate Amazon S3 location from which Amazon ES obtains data.
     */
    public S3DestinationConfiguration s3Configuration() {
        return s3Configuration;
    }

    /**
     * <p>
     * The data processing configuration.
     * </p>
     * 
     * @return The data processing configuration.
     */
    public ProcessingConfiguration processingConfiguration() {
        return processingConfiguration;
    }

    /**
     * <p>
     * The CloudWatch logging options for your delivery stream.
     * </p>
     * 
     * @return The CloudWatch logging options for your delivery stream.
     */
    public CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return cloudWatchLoggingOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((roleARN() == null) ? 0 : roleARN().hashCode());
        hashCode = 31 * hashCode + ((domainARN() == null) ? 0 : domainARN().hashCode());
        hashCode = 31 * hashCode + ((indexName() == null) ? 0 : indexName().hashCode());
        hashCode = 31 * hashCode + ((typeName() == null) ? 0 : typeName().hashCode());
        hashCode = 31 * hashCode + ((indexRotationPeriodString() == null) ? 0 : indexRotationPeriodString().hashCode());
        hashCode = 31 * hashCode + ((bufferingHints() == null) ? 0 : bufferingHints().hashCode());
        hashCode = 31 * hashCode + ((retryOptions() == null) ? 0 : retryOptions().hashCode());
        hashCode = 31 * hashCode + ((s3BackupModeString() == null) ? 0 : s3BackupModeString().hashCode());
        hashCode = 31 * hashCode + ((s3Configuration() == null) ? 0 : s3Configuration().hashCode());
        hashCode = 31 * hashCode + ((processingConfiguration() == null) ? 0 : processingConfiguration().hashCode());
        hashCode = 31 * hashCode + ((cloudWatchLoggingOptions() == null) ? 0 : cloudWatchLoggingOptions().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchDestinationConfiguration)) {
            return false;
        }
        ElasticsearchDestinationConfiguration other = (ElasticsearchDestinationConfiguration) obj;
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.domainARN() == null ^ this.domainARN() == null) {
            return false;
        }
        if (other.domainARN() != null && !other.domainARN().equals(this.domainARN())) {
            return false;
        }
        if (other.indexName() == null ^ this.indexName() == null) {
            return false;
        }
        if (other.indexName() != null && !other.indexName().equals(this.indexName())) {
            return false;
        }
        if (other.typeName() == null ^ this.typeName() == null) {
            return false;
        }
        if (other.typeName() != null && !other.typeName().equals(this.typeName())) {
            return false;
        }
        if (other.indexRotationPeriodString() == null ^ this.indexRotationPeriodString() == null) {
            return false;
        }
        if (other.indexRotationPeriodString() != null
                && !other.indexRotationPeriodString().equals(this.indexRotationPeriodString())) {
            return false;
        }
        if (other.bufferingHints() == null ^ this.bufferingHints() == null) {
            return false;
        }
        if (other.bufferingHints() != null && !other.bufferingHints().equals(this.bufferingHints())) {
            return false;
        }
        if (other.retryOptions() == null ^ this.retryOptions() == null) {
            return false;
        }
        if (other.retryOptions() != null && !other.retryOptions().equals(this.retryOptions())) {
            return false;
        }
        if (other.s3BackupModeString() == null ^ this.s3BackupModeString() == null) {
            return false;
        }
        if (other.s3BackupModeString() != null && !other.s3BackupModeString().equals(this.s3BackupModeString())) {
            return false;
        }
        if (other.s3Configuration() == null ^ this.s3Configuration() == null) {
            return false;
        }
        if (other.s3Configuration() != null && !other.s3Configuration().equals(this.s3Configuration())) {
            return false;
        }
        if (other.processingConfiguration() == null ^ this.processingConfiguration() == null) {
            return false;
        }
        if (other.processingConfiguration() != null && !other.processingConfiguration().equals(this.processingConfiguration())) {
            return false;
        }
        if (other.cloudWatchLoggingOptions() == null ^ this.cloudWatchLoggingOptions() == null) {
            return false;
        }
        if (other.cloudWatchLoggingOptions() != null && !other.cloudWatchLoggingOptions().equals(this.cloudWatchLoggingOptions())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (roleARN() != null) {
            sb.append("RoleARN: ").append(roleARN()).append(",");
        }
        if (domainARN() != null) {
            sb.append("DomainARN: ").append(domainARN()).append(",");
        }
        if (indexName() != null) {
            sb.append("IndexName: ").append(indexName()).append(",");
        }
        if (typeName() != null) {
            sb.append("TypeName: ").append(typeName()).append(",");
        }
        if (indexRotationPeriodString() != null) {
            sb.append("IndexRotationPeriod: ").append(indexRotationPeriodString()).append(",");
        }
        if (bufferingHints() != null) {
            sb.append("BufferingHints: ").append(bufferingHints()).append(",");
        }
        if (retryOptions() != null) {
            sb.append("RetryOptions: ").append(retryOptions()).append(",");
        }
        if (s3BackupModeString() != null) {
            sb.append("S3BackupMode: ").append(s3BackupModeString()).append(",");
        }
        if (s3Configuration() != null) {
            sb.append("S3Configuration: ").append(s3Configuration()).append(",");
        }
        if (processingConfiguration() != null) {
            sb.append("ProcessingConfiguration: ").append(processingConfiguration()).append(",");
        }
        if (cloudWatchLoggingOptions() != null) {
            sb.append("CloudWatchLoggingOptions: ").append(cloudWatchLoggingOptions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleARN":
            return Optional.of(clazz.cast(roleARN()));
        case "DomainARN":
            return Optional.of(clazz.cast(domainARN()));
        case "IndexName":
            return Optional.of(clazz.cast(indexName()));
        case "TypeName":
            return Optional.of(clazz.cast(typeName()));
        case "IndexRotationPeriod":
            return Optional.of(clazz.cast(indexRotationPeriodString()));
        case "BufferingHints":
            return Optional.of(clazz.cast(bufferingHints()));
        case "RetryOptions":
            return Optional.of(clazz.cast(retryOptions()));
        case "S3BackupMode":
            return Optional.of(clazz.cast(s3BackupModeString()));
        case "S3Configuration":
            return Optional.of(clazz.cast(s3Configuration()));
        case "ProcessingConfiguration":
            return Optional.of(clazz.cast(processingConfiguration()));
        case "CloudWatchLoggingOptions":
            return Optional.of(clazz.cast(cloudWatchLoggingOptions()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ElasticsearchDestinationConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ElasticsearchDestinationConfiguration> {
        /**
         * <p>
         * The ARN of the IAM role to be assumed by Firehose for calling the Amazon ES Configuration API and for
         * indexing documents. For more information, see <a
         * href="http://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Amazon S3 Bucket
         * Access</a>.
         * </p>
         * 
         * @param roleARN
         *        The ARN of the IAM role to be assumed by Firehose for calling the Amazon ES Configuration API and for
         *        indexing documents. For more information, see <a
         *        href="http://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Amazon S3
         *        Bucket Access</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The ARN of the Amazon ES domain. The IAM role must have permissions for 
         * <code>DescribeElasticsearchDomain</code>, <code>DescribeElasticsearchDomains</code>, and
         * <code>DescribeElasticsearchDomainConfig</code> after assuming the role specified in <b>RoleARN</b>.
         * </p>
         * 
         * @param domainARN
         *        The ARN of the Amazon ES domain. The IAM role must have permissions for 
         *        <code>DescribeElasticsearchDomain</code>, <code>DescribeElasticsearchDomains</code>, and
         *        <code>DescribeElasticsearchDomainConfig</code> after assuming the role specified in <b>RoleARN</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainARN(String domainARN);

        /**
         * <p>
         * The Elasticsearch index name.
         * </p>
         * 
         * @param indexName
         *        The Elasticsearch index name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The Elasticsearch type name.
         * </p>
         * 
         * @param typeName
         *        The Elasticsearch type name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The Elasticsearch index rotation period. Index rotation appends a timestamp to the IndexName to facilitate
         * expiration of old data. For more information, see <a
         * href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation for
         * Amazon Elasticsearch Service Destination</a>. The default value is <code>OneDay</code>.
         * </p>
         * 
         * @param indexRotationPeriod
         *        The Elasticsearch index rotation period. Index rotation appends a timestamp to the IndexName to
         *        facilitate expiration of old data. For more information, see <a
         *        href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index
         *        Rotation for Amazon Elasticsearch Service Destination</a>. The default value is <code>OneDay</code>.
         * @see ElasticsearchIndexRotationPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ElasticsearchIndexRotationPeriod
         */
        Builder indexRotationPeriod(String indexRotationPeriod);

        /**
         * <p>
         * The Elasticsearch index rotation period. Index rotation appends a timestamp to the IndexName to facilitate
         * expiration of old data. For more information, see <a
         * href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation for
         * Amazon Elasticsearch Service Destination</a>. The default value is <code>OneDay</code>.
         * </p>
         * 
         * @param indexRotationPeriod
         *        The Elasticsearch index rotation period. Index rotation appends a timestamp to the IndexName to
         *        facilitate expiration of old data. For more information, see <a
         *        href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index
         *        Rotation for Amazon Elasticsearch Service Destination</a>. The default value is <code>OneDay</code>.
         * @see ElasticsearchIndexRotationPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ElasticsearchIndexRotationPeriod
         */
        Builder indexRotationPeriod(ElasticsearchIndexRotationPeriod indexRotationPeriod);

        /**
         * <p>
         * The buffering options. If no value is specified, the default values for <b>ElasticsearchBufferingHints</b>
         * are used.
         * </p>
         * 
         * @param bufferingHints
         *        The buffering options. If no value is specified, the default values for
         *        <b>ElasticsearchBufferingHints</b> are used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bufferingHints(ElasticsearchBufferingHints bufferingHints);

        /**
         * <p>
         * The retry behavior in the event that Firehose is unable to deliver documents to Amazon ES. The default value
         * is 300 (5 minutes).
         * </p>
         * 
         * @param retryOptions
         *        The retry behavior in the event that Firehose is unable to deliver documents to Amazon ES. The default
         *        value is 300 (5 minutes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryOptions(ElasticsearchRetryOptions retryOptions);

        /**
         * <p>
         * Defines how documents should be delivered to Amazon S3. When set to FailedDocumentsOnly, Firehose writes any
         * documents that could not be indexed to the configured Amazon S3 destination, with elasticsearch-failed/
         * appended to the key prefix. When set to AllDocuments, Firehose delivers all incoming records to Amazon S3,
         * and also writes failed documents with elasticsearch-failed/ appended to the prefix. For more information, see
         * <a href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-s3-backup">Amazon S3 Backup for
         * Amazon Elasticsearch Service Destination</a>. Default value is FailedDocumentsOnly.
         * </p>
         * 
         * @param s3BackupMode
         *        Defines how documents should be delivered to Amazon S3. When set to FailedDocumentsOnly, Firehose
         *        writes any documents that could not be indexed to the configured Amazon S3 destination, with
         *        elasticsearch-failed/ appended to the key prefix. When set to AllDocuments, Firehose delivers all
         *        incoming records to Amazon S3, and also writes failed documents with elasticsearch-failed/ appended to
         *        the prefix. For more information, see <a
         *        href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-s3-backup">Amazon S3 Backup
         *        for Amazon Elasticsearch Service Destination</a>. Default value is FailedDocumentsOnly.
         * @see ElasticsearchS3BackupMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ElasticsearchS3BackupMode
         */
        Builder s3BackupMode(String s3BackupMode);

        /**
         * <p>
         * Defines how documents should be delivered to Amazon S3. When set to FailedDocumentsOnly, Firehose writes any
         * documents that could not be indexed to the configured Amazon S3 destination, with elasticsearch-failed/
         * appended to the key prefix. When set to AllDocuments, Firehose delivers all incoming records to Amazon S3,
         * and also writes failed documents with elasticsearch-failed/ appended to the prefix. For more information, see
         * <a href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-s3-backup">Amazon S3 Backup for
         * Amazon Elasticsearch Service Destination</a>. Default value is FailedDocumentsOnly.
         * </p>
         * 
         * @param s3BackupMode
         *        Defines how documents should be delivered to Amazon S3. When set to FailedDocumentsOnly, Firehose
         *        writes any documents that could not be indexed to the configured Amazon S3 destination, with
         *        elasticsearch-failed/ appended to the key prefix. When set to AllDocuments, Firehose delivers all
         *        incoming records to Amazon S3, and also writes failed documents with elasticsearch-failed/ appended to
         *        the prefix. For more information, see <a
         *        href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-s3-backup">Amazon S3 Backup
         *        for Amazon Elasticsearch Service Destination</a>. Default value is FailedDocumentsOnly.
         * @see ElasticsearchS3BackupMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ElasticsearchS3BackupMode
         */
        Builder s3BackupMode(ElasticsearchS3BackupMode s3BackupMode);

        /**
         * <p>
         * The configuration for the intermediate Amazon S3 location from which Amazon ES obtains data.
         * </p>
         * 
         * @param s3Configuration
         *        The configuration for the intermediate Amazon S3 location from which Amazon ES obtains data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Configuration(S3DestinationConfiguration s3Configuration);

        /**
         * <p>
         * The data processing configuration.
         * </p>
         * 
         * @param processingConfiguration
         *        The data processing configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingConfiguration(ProcessingConfiguration processingConfiguration);

        /**
         * <p>
         * The CloudWatch logging options for your delivery stream.
         * </p>
         * 
         * @param cloudWatchLoggingOptions
         *        The CloudWatch logging options for your delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions);
    }

    static final class BuilderImpl implements Builder {
        private String roleARN;

        private String domainARN;

        private String indexName;

        private String typeName;

        private String indexRotationPeriod;

        private ElasticsearchBufferingHints bufferingHints;

        private ElasticsearchRetryOptions retryOptions;

        private String s3BackupMode;

        private S3DestinationConfiguration s3Configuration;

        private ProcessingConfiguration processingConfiguration;

        private CloudWatchLoggingOptions cloudWatchLoggingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchDestinationConfiguration model) {
            roleARN(model.roleARN);
            domainARN(model.domainARN);
            indexName(model.indexName);
            typeName(model.typeName);
            indexRotationPeriod(model.indexRotationPeriod);
            bufferingHints(model.bufferingHints);
            retryOptions(model.retryOptions);
            s3BackupMode(model.s3BackupMode);
            s3Configuration(model.s3Configuration);
            processingConfiguration(model.processingConfiguration);
            cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getDomainARN() {
            return domainARN;
        }

        @Override
        public final Builder domainARN(String domainARN) {
            this.domainARN = domainARN;
            return this;
        }

        public final void setDomainARN(String domainARN) {
            this.domainARN = domainARN;
        }

        public final String getIndexName() {
            return indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final String getTypeName() {
            return typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getIndexRotationPeriod() {
            return indexRotationPeriod;
        }

        @Override
        public final Builder indexRotationPeriod(String indexRotationPeriod) {
            this.indexRotationPeriod = indexRotationPeriod;
            return this;
        }

        @Override
        public final Builder indexRotationPeriod(ElasticsearchIndexRotationPeriod indexRotationPeriod) {
            this.indexRotationPeriod(indexRotationPeriod.toString());
            return this;
        }

        public final void setIndexRotationPeriod(String indexRotationPeriod) {
            this.indexRotationPeriod = indexRotationPeriod;
        }

        public final ElasticsearchBufferingHints.Builder getBufferingHints() {
            return bufferingHints != null ? bufferingHints.toBuilder() : null;
        }

        @Override
        public final Builder bufferingHints(ElasticsearchBufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final void setBufferingHints(ElasticsearchBufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        public final ElasticsearchRetryOptions.Builder getRetryOptions() {
            return retryOptions != null ? retryOptions.toBuilder() : null;
        }

        @Override
        public final Builder retryOptions(ElasticsearchRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final void setRetryOptions(ElasticsearchRetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        public final String getS3BackupMode() {
            return s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(ElasticsearchS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode.toString());
            return this;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        public final S3DestinationConfiguration.Builder getS3Configuration() {
            return s3Configuration != null ? s3Configuration.toBuilder() : null;
        }

        @Override
        public final Builder s3Configuration(S3DestinationConfiguration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public final void setS3Configuration(S3DestinationConfiguration.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return processingConfiguration != null ? processingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        @Override
        public ElasticsearchDestinationConfiguration build() {
            return new ElasticsearchDestinationConfiguration(this);
        }
    }
}
