/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.DestinationDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the destination for a delivery stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DestinationDescription implements StructuredPojo,
        ToCopyableBuilder<DestinationDescription.Builder, DestinationDescription> {
    private final String destinationId;

    private final S3DestinationDescription s3DestinationDescription;

    private final ExtendedS3DestinationDescription extendedS3DestinationDescription;

    private final RedshiftDestinationDescription redshiftDestinationDescription;

    private final ElasticsearchDestinationDescription elasticsearchDestinationDescription;

    private DestinationDescription(BuilderImpl builder) {
        this.destinationId = builder.destinationId;
        this.s3DestinationDescription = builder.s3DestinationDescription;
        this.extendedS3DestinationDescription = builder.extendedS3DestinationDescription;
        this.redshiftDestinationDescription = builder.redshiftDestinationDescription;
        this.elasticsearchDestinationDescription = builder.elasticsearchDestinationDescription;
    }

    /**
     * <p>
     * The ID of the destination.
     * </p>
     * 
     * @return The ID of the destination.
     */
    public String destinationId() {
        return destinationId;
    }

    /**
     * <p>
     * [Deprecated] The destination in Amazon S3.
     * </p>
     * 
     * @return [Deprecated] The destination in Amazon S3.
     */
    public S3DestinationDescription s3DestinationDescription() {
        return s3DestinationDescription;
    }

    /**
     * <p>
     * The destination in Amazon S3.
     * </p>
     * 
     * @return The destination in Amazon S3.
     */
    public ExtendedS3DestinationDescription extendedS3DestinationDescription() {
        return extendedS3DestinationDescription;
    }

    /**
     * <p>
     * The destination in Amazon Redshift.
     * </p>
     * 
     * @return The destination in Amazon Redshift.
     */
    public RedshiftDestinationDescription redshiftDestinationDescription() {
        return redshiftDestinationDescription;
    }

    /**
     * <p>
     * The destination in Amazon ES.
     * </p>
     * 
     * @return The destination in Amazon ES.
     */
    public ElasticsearchDestinationDescription elasticsearchDestinationDescription() {
        return elasticsearchDestinationDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((destinationId() == null) ? 0 : destinationId().hashCode());
        hashCode = 31 * hashCode + ((s3DestinationDescription() == null) ? 0 : s3DestinationDescription().hashCode());
        hashCode = 31 * hashCode
                + ((extendedS3DestinationDescription() == null) ? 0 : extendedS3DestinationDescription().hashCode());
        hashCode = 31 * hashCode + ((redshiftDestinationDescription() == null) ? 0 : redshiftDestinationDescription().hashCode());
        hashCode = 31 * hashCode
                + ((elasticsearchDestinationDescription() == null) ? 0 : elasticsearchDestinationDescription().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationDescription)) {
            return false;
        }
        DestinationDescription other = (DestinationDescription) obj;
        if (other.destinationId() == null ^ this.destinationId() == null) {
            return false;
        }
        if (other.destinationId() != null && !other.destinationId().equals(this.destinationId())) {
            return false;
        }
        if (other.s3DestinationDescription() == null ^ this.s3DestinationDescription() == null) {
            return false;
        }
        if (other.s3DestinationDescription() != null && !other.s3DestinationDescription().equals(this.s3DestinationDescription())) {
            return false;
        }
        if (other.extendedS3DestinationDescription() == null ^ this.extendedS3DestinationDescription() == null) {
            return false;
        }
        if (other.extendedS3DestinationDescription() != null
                && !other.extendedS3DestinationDescription().equals(this.extendedS3DestinationDescription())) {
            return false;
        }
        if (other.redshiftDestinationDescription() == null ^ this.redshiftDestinationDescription() == null) {
            return false;
        }
        if (other.redshiftDestinationDescription() != null
                && !other.redshiftDestinationDescription().equals(this.redshiftDestinationDescription())) {
            return false;
        }
        if (other.elasticsearchDestinationDescription() == null ^ this.elasticsearchDestinationDescription() == null) {
            return false;
        }
        if (other.elasticsearchDestinationDescription() != null
                && !other.elasticsearchDestinationDescription().equals(this.elasticsearchDestinationDescription())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (destinationId() != null) {
            sb.append("DestinationId: ").append(destinationId()).append(",");
        }
        if (s3DestinationDescription() != null) {
            sb.append("S3DestinationDescription: ").append(s3DestinationDescription()).append(",");
        }
        if (extendedS3DestinationDescription() != null) {
            sb.append("ExtendedS3DestinationDescription: ").append(extendedS3DestinationDescription()).append(",");
        }
        if (redshiftDestinationDescription() != null) {
            sb.append("RedshiftDestinationDescription: ").append(redshiftDestinationDescription()).append(",");
        }
        if (elasticsearchDestinationDescription() != null) {
            sb.append("ElasticsearchDestinationDescription: ").append(elasticsearchDestinationDescription()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationId":
            return Optional.of(clazz.cast(destinationId()));
        case "S3DestinationDescription":
            return Optional.of(clazz.cast(s3DestinationDescription()));
        case "ExtendedS3DestinationDescription":
            return Optional.of(clazz.cast(extendedS3DestinationDescription()));
        case "RedshiftDestinationDescription":
            return Optional.of(clazz.cast(redshiftDestinationDescription()));
        case "ElasticsearchDestinationDescription":
            return Optional.of(clazz.cast(elasticsearchDestinationDescription()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DestinationDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DestinationDescription> {
        /**
         * <p>
         * The ID of the destination.
         * </p>
         * 
         * @param destinationId
         *        The ID of the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationId(String destinationId);

        /**
         * <p>
         * [Deprecated] The destination in Amazon S3.
         * </p>
         * 
         * @param s3DestinationDescription
         *        [Deprecated] The destination in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DestinationDescription(S3DestinationDescription s3DestinationDescription);

        /**
         * <p>
         * The destination in Amazon S3.
         * </p>
         * 
         * @param extendedS3DestinationDescription
         *        The destination in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendedS3DestinationDescription(ExtendedS3DestinationDescription extendedS3DestinationDescription);

        /**
         * <p>
         * The destination in Amazon Redshift.
         * </p>
         * 
         * @param redshiftDestinationDescription
         *        The destination in Amazon Redshift.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftDestinationDescription(RedshiftDestinationDescription redshiftDestinationDescription);

        /**
         * <p>
         * The destination in Amazon ES.
         * </p>
         * 
         * @param elasticsearchDestinationDescription
         *        The destination in Amazon ES.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticsearchDestinationDescription(ElasticsearchDestinationDescription elasticsearchDestinationDescription);
    }

    static final class BuilderImpl implements Builder {
        private String destinationId;

        private S3DestinationDescription s3DestinationDescription;

        private ExtendedS3DestinationDescription extendedS3DestinationDescription;

        private RedshiftDestinationDescription redshiftDestinationDescription;

        private ElasticsearchDestinationDescription elasticsearchDestinationDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationDescription model) {
            destinationId(model.destinationId);
            s3DestinationDescription(model.s3DestinationDescription);
            extendedS3DestinationDescription(model.extendedS3DestinationDescription);
            redshiftDestinationDescription(model.redshiftDestinationDescription);
            elasticsearchDestinationDescription(model.elasticsearchDestinationDescription);
        }

        public final String getDestinationId() {
            return destinationId;
        }

        @Override
        public final Builder destinationId(String destinationId) {
            this.destinationId = destinationId;
            return this;
        }

        public final void setDestinationId(String destinationId) {
            this.destinationId = destinationId;
        }

        public final S3DestinationDescription.Builder getS3DestinationDescription() {
            return s3DestinationDescription != null ? s3DestinationDescription.toBuilder() : null;
        }

        @Override
        public final Builder s3DestinationDescription(S3DestinationDescription s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription;
            return this;
        }

        public final void setS3DestinationDescription(S3DestinationDescription.BuilderImpl s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription != null ? s3DestinationDescription.build() : null;
        }

        public final ExtendedS3DestinationDescription.Builder getExtendedS3DestinationDescription() {
            return extendedS3DestinationDescription != null ? extendedS3DestinationDescription.toBuilder() : null;
        }

        @Override
        public final Builder extendedS3DestinationDescription(ExtendedS3DestinationDescription extendedS3DestinationDescription) {
            this.extendedS3DestinationDescription = extendedS3DestinationDescription;
            return this;
        }

        public final void setExtendedS3DestinationDescription(
                ExtendedS3DestinationDescription.BuilderImpl extendedS3DestinationDescription) {
            this.extendedS3DestinationDescription = extendedS3DestinationDescription != null ? extendedS3DestinationDescription
                    .build() : null;
        }

        public final RedshiftDestinationDescription.Builder getRedshiftDestinationDescription() {
            return redshiftDestinationDescription != null ? redshiftDestinationDescription.toBuilder() : null;
        }

        @Override
        public final Builder redshiftDestinationDescription(RedshiftDestinationDescription redshiftDestinationDescription) {
            this.redshiftDestinationDescription = redshiftDestinationDescription;
            return this;
        }

        public final void setRedshiftDestinationDescription(
                RedshiftDestinationDescription.BuilderImpl redshiftDestinationDescription) {
            this.redshiftDestinationDescription = redshiftDestinationDescription != null ? redshiftDestinationDescription.build()
                    : null;
        }

        public final ElasticsearchDestinationDescription.Builder getElasticsearchDestinationDescription() {
            return elasticsearchDestinationDescription != null ? elasticsearchDestinationDescription.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearchDestinationDescription(
                ElasticsearchDestinationDescription elasticsearchDestinationDescription) {
            this.elasticsearchDestinationDescription = elasticsearchDestinationDescription;
            return this;
        }

        public final void setElasticsearchDestinationDescription(
                ElasticsearchDestinationDescription.BuilderImpl elasticsearchDestinationDescription) {
            this.elasticsearchDestinationDescription = elasticsearchDestinationDescription != null ? elasticsearchDestinationDescription
                    .build() : null;
        }

        @Override
        public DestinationDescription build() {
            return new DestinationDescription(this);
        }
    }
}
