/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateDeliveryStreamRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateDeliveryStreamRequest.Builder, CreateDeliveryStreamRequest> {
    private final String deliveryStreamName;

    private final S3DestinationConfiguration s3DestinationConfiguration;

    private final ExtendedS3DestinationConfiguration extendedS3DestinationConfiguration;

    private final RedshiftDestinationConfiguration redshiftDestinationConfiguration;

    private final ElasticsearchDestinationConfiguration elasticsearchDestinationConfiguration;

    private CreateDeliveryStreamRequest(BuilderImpl builder) {
        this.deliveryStreamName = builder.deliveryStreamName;
        this.s3DestinationConfiguration = builder.s3DestinationConfiguration;
        this.extendedS3DestinationConfiguration = builder.extendedS3DestinationConfiguration;
        this.redshiftDestinationConfiguration = builder.redshiftDestinationConfiguration;
        this.elasticsearchDestinationConfiguration = builder.elasticsearchDestinationConfiguration;
    }

    /**
     * <p>
     * The name of the delivery stream. This name must be unique per AWS account in the same region. You can have
     * multiple delivery streams with the same name if they are in different accounts or different regions.
     * </p>
     * 
     * @return The name of the delivery stream. This name must be unique per AWS account in the same region. You can
     *         have multiple delivery streams with the same name if they are in different accounts or different regions.
     */
    public String deliveryStreamName() {
        return deliveryStreamName;
    }

    /**
     * <p>
     * [Deprecated] The destination in Amazon S3. You can specify only one destination.
     * </p>
     * 
     * @return [Deprecated] The destination in Amazon S3. You can specify only one destination.
     */
    public S3DestinationConfiguration s3DestinationConfiguration() {
        return s3DestinationConfiguration;
    }

    /**
     * <p>
     * The destination in Amazon S3. You can specify only one destination.
     * </p>
     * 
     * @return The destination in Amazon S3. You can specify only one destination.
     */
    public ExtendedS3DestinationConfiguration extendedS3DestinationConfiguration() {
        return extendedS3DestinationConfiguration;
    }

    /**
     * <p>
     * The destination in Amazon Redshift. You can specify only one destination.
     * </p>
     * 
     * @return The destination in Amazon Redshift. You can specify only one destination.
     */
    public RedshiftDestinationConfiguration redshiftDestinationConfiguration() {
        return redshiftDestinationConfiguration;
    }

    /**
     * <p>
     * The destination in Amazon ES. You can specify only one destination.
     * </p>
     * 
     * @return The destination in Amazon ES. You can specify only one destination.
     */
    public ElasticsearchDestinationConfiguration elasticsearchDestinationConfiguration() {
        return elasticsearchDestinationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deliveryStreamName() == null) ? 0 : deliveryStreamName().hashCode());
        hashCode = 31 * hashCode + ((s3DestinationConfiguration() == null) ? 0 : s3DestinationConfiguration().hashCode());
        hashCode = 31 * hashCode
                + ((extendedS3DestinationConfiguration() == null) ? 0 : extendedS3DestinationConfiguration().hashCode());
        hashCode = 31 * hashCode
                + ((redshiftDestinationConfiguration() == null) ? 0 : redshiftDestinationConfiguration().hashCode());
        hashCode = 31 * hashCode
                + ((elasticsearchDestinationConfiguration() == null) ? 0 : elasticsearchDestinationConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeliveryStreamRequest)) {
            return false;
        }
        CreateDeliveryStreamRequest other = (CreateDeliveryStreamRequest) obj;
        if (other.deliveryStreamName() == null ^ this.deliveryStreamName() == null) {
            return false;
        }
        if (other.deliveryStreamName() != null && !other.deliveryStreamName().equals(this.deliveryStreamName())) {
            return false;
        }
        if (other.s3DestinationConfiguration() == null ^ this.s3DestinationConfiguration() == null) {
            return false;
        }
        if (other.s3DestinationConfiguration() != null
                && !other.s3DestinationConfiguration().equals(this.s3DestinationConfiguration())) {
            return false;
        }
        if (other.extendedS3DestinationConfiguration() == null ^ this.extendedS3DestinationConfiguration() == null) {
            return false;
        }
        if (other.extendedS3DestinationConfiguration() != null
                && !other.extendedS3DestinationConfiguration().equals(this.extendedS3DestinationConfiguration())) {
            return false;
        }
        if (other.redshiftDestinationConfiguration() == null ^ this.redshiftDestinationConfiguration() == null) {
            return false;
        }
        if (other.redshiftDestinationConfiguration() != null
                && !other.redshiftDestinationConfiguration().equals(this.redshiftDestinationConfiguration())) {
            return false;
        }
        if (other.elasticsearchDestinationConfiguration() == null ^ this.elasticsearchDestinationConfiguration() == null) {
            return false;
        }
        if (other.elasticsearchDestinationConfiguration() != null
                && !other.elasticsearchDestinationConfiguration().equals(this.elasticsearchDestinationConfiguration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (deliveryStreamName() != null) {
            sb.append("DeliveryStreamName: ").append(deliveryStreamName()).append(",");
        }
        if (s3DestinationConfiguration() != null) {
            sb.append("S3DestinationConfiguration: ").append(s3DestinationConfiguration()).append(",");
        }
        if (extendedS3DestinationConfiguration() != null) {
            sb.append("ExtendedS3DestinationConfiguration: ").append(extendedS3DestinationConfiguration()).append(",");
        }
        if (redshiftDestinationConfiguration() != null) {
            sb.append("RedshiftDestinationConfiguration: ").append(redshiftDestinationConfiguration()).append(",");
        }
        if (elasticsearchDestinationConfiguration() != null) {
            sb.append("ElasticsearchDestinationConfiguration: ").append(elasticsearchDestinationConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryStreamName":
            return Optional.of(clazz.cast(deliveryStreamName()));
        case "S3DestinationConfiguration":
            return Optional.of(clazz.cast(s3DestinationConfiguration()));
        case "ExtendedS3DestinationConfiguration":
            return Optional.of(clazz.cast(extendedS3DestinationConfiguration()));
        case "RedshiftDestinationConfiguration":
            return Optional.of(clazz.cast(redshiftDestinationConfiguration()));
        case "ElasticsearchDestinationConfiguration":
            return Optional.of(clazz.cast(elasticsearchDestinationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateDeliveryStreamRequest> {
        /**
         * <p>
         * The name of the delivery stream. This name must be unique per AWS account in the same region. You can have
         * multiple delivery streams with the same name if they are in different accounts or different regions.
         * </p>
         * 
         * @param deliveryStreamName
         *        The name of the delivery stream. This name must be unique per AWS account in the same region. You can
         *        have multiple delivery streams with the same name if they are in different accounts or different
         *        regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamName(String deliveryStreamName);

        /**
         * <p>
         * [Deprecated] The destination in Amazon S3. You can specify only one destination.
         * </p>
         * 
         * @param s3DestinationConfiguration
         *        [Deprecated] The destination in Amazon S3. You can specify only one destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DestinationConfiguration(S3DestinationConfiguration s3DestinationConfiguration);

        /**
         * <p>
         * The destination in Amazon S3. You can specify only one destination.
         * </p>
         * 
         * @param extendedS3DestinationConfiguration
         *        The destination in Amazon S3. You can specify only one destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendedS3DestinationConfiguration(ExtendedS3DestinationConfiguration extendedS3DestinationConfiguration);

        /**
         * <p>
         * The destination in Amazon Redshift. You can specify only one destination.
         * </p>
         * 
         * @param redshiftDestinationConfiguration
         *        The destination in Amazon Redshift. You can specify only one destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftDestinationConfiguration(RedshiftDestinationConfiguration redshiftDestinationConfiguration);

        /**
         * <p>
         * The destination in Amazon ES. You can specify only one destination.
         * </p>
         * 
         * @param elasticsearchDestinationConfiguration
         *        The destination in Amazon ES. You can specify only one destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticsearchDestinationConfiguration(ElasticsearchDestinationConfiguration elasticsearchDestinationConfiguration);
    }

    static final class BuilderImpl implements Builder {
        private String deliveryStreamName;

        private S3DestinationConfiguration s3DestinationConfiguration;

        private ExtendedS3DestinationConfiguration extendedS3DestinationConfiguration;

        private RedshiftDestinationConfiguration redshiftDestinationConfiguration;

        private ElasticsearchDestinationConfiguration elasticsearchDestinationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeliveryStreamRequest model) {
            deliveryStreamName(model.deliveryStreamName);
            s3DestinationConfiguration(model.s3DestinationConfiguration);
            extendedS3DestinationConfiguration(model.extendedS3DestinationConfiguration);
            redshiftDestinationConfiguration(model.redshiftDestinationConfiguration);
            elasticsearchDestinationConfiguration(model.elasticsearchDestinationConfiguration);
        }

        public final String getDeliveryStreamName() {
            return deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        public final S3DestinationConfiguration.Builder getS3DestinationConfiguration() {
            return s3DestinationConfiguration != null ? s3DestinationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder s3DestinationConfiguration(S3DestinationConfiguration s3DestinationConfiguration) {
            this.s3DestinationConfiguration = s3DestinationConfiguration;
            return this;
        }

        public final void setS3DestinationConfiguration(S3DestinationConfiguration.BuilderImpl s3DestinationConfiguration) {
            this.s3DestinationConfiguration = s3DestinationConfiguration != null ? s3DestinationConfiguration.build() : null;
        }

        public final ExtendedS3DestinationConfiguration.Builder getExtendedS3DestinationConfiguration() {
            return extendedS3DestinationConfiguration != null ? extendedS3DestinationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder extendedS3DestinationConfiguration(
                ExtendedS3DestinationConfiguration extendedS3DestinationConfiguration) {
            this.extendedS3DestinationConfiguration = extendedS3DestinationConfiguration;
            return this;
        }

        public final void setExtendedS3DestinationConfiguration(
                ExtendedS3DestinationConfiguration.BuilderImpl extendedS3DestinationConfiguration) {
            this.extendedS3DestinationConfiguration = extendedS3DestinationConfiguration != null ? extendedS3DestinationConfiguration
                    .build() : null;
        }

        public final RedshiftDestinationConfiguration.Builder getRedshiftDestinationConfiguration() {
            return redshiftDestinationConfiguration != null ? redshiftDestinationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder redshiftDestinationConfiguration(RedshiftDestinationConfiguration redshiftDestinationConfiguration) {
            this.redshiftDestinationConfiguration = redshiftDestinationConfiguration;
            return this;
        }

        public final void setRedshiftDestinationConfiguration(
                RedshiftDestinationConfiguration.BuilderImpl redshiftDestinationConfiguration) {
            this.redshiftDestinationConfiguration = redshiftDestinationConfiguration != null ? redshiftDestinationConfiguration
                    .build() : null;
        }

        public final ElasticsearchDestinationConfiguration.Builder getElasticsearchDestinationConfiguration() {
            return elasticsearchDestinationConfiguration != null ? elasticsearchDestinationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearchDestinationConfiguration(
                ElasticsearchDestinationConfiguration elasticsearchDestinationConfiguration) {
            this.elasticsearchDestinationConfiguration = elasticsearchDestinationConfiguration;
            return this;
        }

        public final void setElasticsearchDestinationConfiguration(
                ElasticsearchDestinationConfiguration.BuilderImpl elasticsearchDestinationConfiguration) {
            this.elasticsearchDestinationConfiguration = elasticsearchDestinationConfiguration != null ? elasticsearchDestinationConfiguration
                    .build() : null;
        }

        @Override
        public CreateDeliveryStreamRequest build() {
            return new CreateDeliveryStreamRequest(this);
        }
    }
}
