/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.CopyCommandMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a <code>COPY</code> command for Amazon Redshift.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CopyCommand implements StructuredPojo, ToCopyableBuilder<CopyCommand.Builder, CopyCommand> {
    private final String dataTableName;

    private final String dataTableColumns;

    private final String copyOptions;

    private CopyCommand(BuilderImpl builder) {
        this.dataTableName = builder.dataTableName;
        this.dataTableColumns = builder.dataTableColumns;
        this.copyOptions = builder.copyOptions;
    }

    /**
     * <p>
     * The name of the target table. The table must already exist in the database.
     * </p>
     * 
     * @return The name of the target table. The table must already exist in the database.
     */
    public String dataTableName() {
        return dataTableName;
    }

    /**
     * <p>
     * A comma-separated list of column names.
     * </p>
     * 
     * @return A comma-separated list of column names.
     */
    public String dataTableColumns() {
        return dataTableColumns;
    }

    /**
     * <p>
     * Optional parameters to use with the Amazon Redshift <code>COPY</code> command. For more information, see the
     * "Optional Parameters" section of <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html">Amazon
     * Redshift COPY command</a>. Some possible examples that would apply to Firehose are as follows:
     * </p>
     * <p>
     * <code>delimiter '\t' lzop;</code> - fields are delimited with "\t" (TAB character) and compressed using lzop.
     * </p>
     * <p>
     * <code>delimiter '|</code> - fields are delimited with "|" (this is the default delimiter).
     * </p>
     * <p>
     * <code>delimiter '|' escape</code> - the delimiter should be escaped.
     * </p>
     * <p>
     * <code>fixedwidth 'venueid:3,venuename:25,venuecity:12,venuestate:2,venueseats:6'</code> - fields are fixed width
     * in the source, with each width specified after every column in the table.
     * </p>
     * <p>
     * <code>JSON 's3://mybucket/jsonpaths.txt'</code> - data is in JSON format, and the path specified is the format of
     * the data.
     * </p>
     * <p>
     * For more examples, see <a
     * href="http://docs.aws.amazon.com/redshift/latest/dg/r_COPY_command_examples.html">Amazon Redshift COPY command
     * examples</a>.
     * </p>
     * 
     * @return Optional parameters to use with the Amazon Redshift <code>COPY</code> command. For more information, see
     *         the "Optional Parameters" section of <a
     *         href="http://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html">Amazon Redshift COPY command</a>. Some
     *         possible examples that would apply to Firehose are as follows:</p>
     *         <p>
     *         <code>delimiter '\t' lzop;</code> - fields are delimited with "\t" (TAB character) and compressed using
     *         lzop.
     *         </p>
     *         <p>
     *         <code>delimiter '|</code> - fields are delimited with "|" (this is the default delimiter).
     *         </p>
     *         <p>
     *         <code>delimiter '|' escape</code> - the delimiter should be escaped.
     *         </p>
     *         <p>
     *         <code>fixedwidth 'venueid:3,venuename:25,venuecity:12,venuestate:2,venueseats:6'</code> - fields are
     *         fixed width in the source, with each width specified after every column in the table.
     *         </p>
     *         <p>
     *         <code>JSON 's3://mybucket/jsonpaths.txt'</code> - data is in JSON format, and the path specified is the
     *         format of the data.
     *         </p>
     *         <p>
     *         For more examples, see <a
     *         href="http://docs.aws.amazon.com/redshift/latest/dg/r_COPY_command_examples.html">Amazon Redshift COPY
     *         command examples</a>.
     */
    public String copyOptions() {
        return copyOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((dataTableName() == null) ? 0 : dataTableName().hashCode());
        hashCode = 31 * hashCode + ((dataTableColumns() == null) ? 0 : dataTableColumns().hashCode());
        hashCode = 31 * hashCode + ((copyOptions() == null) ? 0 : copyOptions().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyCommand)) {
            return false;
        }
        CopyCommand other = (CopyCommand) obj;
        if (other.dataTableName() == null ^ this.dataTableName() == null) {
            return false;
        }
        if (other.dataTableName() != null && !other.dataTableName().equals(this.dataTableName())) {
            return false;
        }
        if (other.dataTableColumns() == null ^ this.dataTableColumns() == null) {
            return false;
        }
        if (other.dataTableColumns() != null && !other.dataTableColumns().equals(this.dataTableColumns())) {
            return false;
        }
        if (other.copyOptions() == null ^ this.copyOptions() == null) {
            return false;
        }
        if (other.copyOptions() != null && !other.copyOptions().equals(this.copyOptions())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (dataTableName() != null) {
            sb.append("DataTableName: ").append(dataTableName()).append(",");
        }
        if (dataTableColumns() != null) {
            sb.append("DataTableColumns: ").append(dataTableColumns()).append(",");
        }
        if (copyOptions() != null) {
            sb.append("CopyOptions: ").append(copyOptions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataTableName":
            return Optional.of(clazz.cast(dataTableName()));
        case "DataTableColumns":
            return Optional.of(clazz.cast(dataTableColumns()));
        case "CopyOptions":
            return Optional.of(clazz.cast(copyOptions()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CopyCommandMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CopyCommand> {
        /**
         * <p>
         * The name of the target table. The table must already exist in the database.
         * </p>
         * 
         * @param dataTableName
         *        The name of the target table. The table must already exist in the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTableName(String dataTableName);

        /**
         * <p>
         * A comma-separated list of column names.
         * </p>
         * 
         * @param dataTableColumns
         *        A comma-separated list of column names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTableColumns(String dataTableColumns);

        /**
         * <p>
         * Optional parameters to use with the Amazon Redshift <code>COPY</code> command. For more information, see the
         * "Optional Parameters" section of <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html">Amazon
         * Redshift COPY command</a>. Some possible examples that would apply to Firehose are as follows:
         * </p>
         * <p>
         * <code>delimiter '\t' lzop;</code> - fields are delimited with "\t" (TAB character) and compressed using lzop.
         * </p>
         * <p>
         * <code>delimiter '|</code> - fields are delimited with "|" (this is the default delimiter).
         * </p>
         * <p>
         * <code>delimiter '|' escape</code> - the delimiter should be escaped.
         * </p>
         * <p>
         * <code>fixedwidth 'venueid:3,venuename:25,venuecity:12,venuestate:2,venueseats:6'</code> - fields are fixed
         * width in the source, with each width specified after every column in the table.
         * </p>
         * <p>
         * <code>JSON 's3://mybucket/jsonpaths.txt'</code> - data is in JSON format, and the path specified is the
         * format of the data.
         * </p>
         * <p>
         * For more examples, see <a
         * href="http://docs.aws.amazon.com/redshift/latest/dg/r_COPY_command_examples.html">Amazon Redshift COPY
         * command examples</a>.
         * </p>
         * 
         * @param copyOptions
         *        Optional parameters to use with the Amazon Redshift <code>COPY</code> command. For more information,
         *        see the "Optional Parameters" section of <a
         *        href="http://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html">Amazon Redshift COPY command</a>.
         *        Some possible examples that would apply to Firehose are as follows:</p>
         *        <p>
         *        <code>delimiter '\t' lzop;</code> - fields are delimited with "\t" (TAB character) and compressed
         *        using lzop.
         *        </p>
         *        <p>
         *        <code>delimiter '|</code> - fields are delimited with "|" (this is the default delimiter).
         *        </p>
         *        <p>
         *        <code>delimiter '|' escape</code> - the delimiter should be escaped.
         *        </p>
         *        <p>
         *        <code>fixedwidth 'venueid:3,venuename:25,venuecity:12,venuestate:2,venueseats:6'</code> - fields are
         *        fixed width in the source, with each width specified after every column in the table.
         *        </p>
         *        <p>
         *        <code>JSON 's3://mybucket/jsonpaths.txt'</code> - data is in JSON format, and the path specified is
         *        the format of the data.
         *        </p>
         *        <p>
         *        For more examples, see <a
         *        href="http://docs.aws.amazon.com/redshift/latest/dg/r_COPY_command_examples.html">Amazon Redshift COPY
         *        command examples</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyOptions(String copyOptions);
    }

    static final class BuilderImpl implements Builder {
        private String dataTableName;

        private String dataTableColumns;

        private String copyOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyCommand model) {
            dataTableName(model.dataTableName);
            dataTableColumns(model.dataTableColumns);
            copyOptions(model.copyOptions);
        }

        public final String getDataTableName() {
            return dataTableName;
        }

        @Override
        public final Builder dataTableName(String dataTableName) {
            this.dataTableName = dataTableName;
            return this;
        }

        public final void setDataTableName(String dataTableName) {
            this.dataTableName = dataTableName;
        }

        public final String getDataTableColumns() {
            return dataTableColumns;
        }

        @Override
        public final Builder dataTableColumns(String dataTableColumns) {
            this.dataTableColumns = dataTableColumns;
            return this;
        }

        public final void setDataTableColumns(String dataTableColumns) {
            this.dataTableColumns = dataTableColumns;
        }

        public final String getCopyOptions() {
            return copyOptions;
        }

        @Override
        public final Builder copyOptions(String copyOptions) {
            this.copyOptions = copyOptions;
            return this;
        }

        public final void setCopyOptions(String copyOptions) {
            this.copyOptions = copyOptions;
        }

        @Override
        public CopyCommand build() {
            return new CopyCommand(this);
        }
    }
}
