/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.kinesisanalytics.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * InputDescription JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class InputDescriptionUnmarshaller implements Unmarshaller<InputDescription, JsonUnmarshallerContext> {

    public InputDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        InputDescription.Builder inputDescriptionBuilder = InputDescription.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("InputId", targetDepth)) {
                    context.nextToken();
                    inputDescriptionBuilder.inputId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("NamePrefix", targetDepth)) {
                    context.nextToken();
                    inputDescriptionBuilder.namePrefix(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("InAppStreamNames", targetDepth)) {
                    context.nextToken();
                    inputDescriptionBuilder.inAppStreamNames(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))
                            .unmarshall(context));
                }
                if (context.testExpression("KinesisStreamsInputDescription", targetDepth)) {
                    context.nextToken();
                    inputDescriptionBuilder.kinesisStreamsInputDescription(KinesisStreamsInputDescriptionUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("KinesisFirehoseInputDescription", targetDepth)) {
                    context.nextToken();
                    inputDescriptionBuilder.kinesisFirehoseInputDescription(KinesisFirehoseInputDescriptionUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("InputSchema", targetDepth)) {
                    context.nextToken();
                    inputDescriptionBuilder.inputSchema(SourceSchemaUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("InputParallelism", targetDepth)) {
                    context.nextToken();
                    inputDescriptionBuilder.inputParallelism(InputParallelismUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("InputStartingPositionConfiguration", targetDepth)) {
                    context.nextToken();
                    inputDescriptionBuilder.inputStartingPositionConfiguration(InputStartingPositionConfigurationUnmarshaller
                            .getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return inputDescriptionBuilder.build();
    }

    private static final InputDescriptionUnmarshaller INSTANCE = new InputDescriptionUnmarshaller();

    public static InputDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}
