/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.DestinationSchemaMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the data format when records are written to the destination. For more information, see <a
 * href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html">Configuring Application
 * Output</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DestinationSchema implements StructuredPojo, ToCopyableBuilder<DestinationSchema.Builder, DestinationSchema> {
    private final String recordFormatType;

    private DestinationSchema(BuilderImpl builder) {
        this.recordFormatType = builder.recordFormatType;
    }

    /**
     * <p>
     * Specifies the format of the records on the output stream.
     * </p>
     * 
     * @return Specifies the format of the records on the output stream.
     * @see RecordFormatType
     */
    public String recordFormatType() {
        return recordFormatType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((recordFormatType() == null) ? 0 : recordFormatType().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationSchema)) {
            return false;
        }
        DestinationSchema other = (DestinationSchema) obj;
        if (other.recordFormatType() == null ^ this.recordFormatType() == null) {
            return false;
        }
        if (other.recordFormatType() != null && !other.recordFormatType().equals(this.recordFormatType())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (recordFormatType() != null) {
            sb.append("RecordFormatType: ").append(recordFormatType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DestinationSchemaMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DestinationSchema> {
        /**
         * <p>
         * Specifies the format of the records on the output stream.
         * </p>
         * 
         * @param recordFormatType
         *        Specifies the format of the records on the output stream.
         * @see RecordFormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordFormatType
         */
        Builder recordFormatType(String recordFormatType);

        /**
         * <p>
         * Specifies the format of the records on the output stream.
         * </p>
         * 
         * @param recordFormatType
         *        Specifies the format of the records on the output stream.
         * @see RecordFormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordFormatType
         */
        Builder recordFormatType(RecordFormatType recordFormatType);
    }

    private static final class BuilderImpl implements Builder {
        private String recordFormatType;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationSchema model) {
            setRecordFormatType(model.recordFormatType);
        }

        public final String getRecordFormatType() {
            return recordFormatType;
        }

        @Override
        public final Builder recordFormatType(String recordFormatType) {
            this.recordFormatType = recordFormatType;
            return this;
        }

        @Override
        public final Builder recordFormatType(RecordFormatType recordFormatType) {
            this.recordFormatType(recordFormatType.toString());
            return this;
        }

        public final void setRecordFormatType(String recordFormatType) {
            this.recordFormatType = recordFormatType;
        }

        @Override
        public DestinationSchema build() {
            return new DestinationSchema(this);
        }
    }
}
