/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class AddApplicationReferenceDataSourceRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<AddApplicationReferenceDataSourceRequest.Builder, AddApplicationReferenceDataSourceRequest> {
    private final String applicationName;

    private final Long currentApplicationVersionId;

    private final ReferenceDataSource referenceDataSource;

    private AddApplicationReferenceDataSourceRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.referenceDataSource = builder.referenceDataSource;
    }

    /**
     * <p>
     * Name of an existing application.
     * </p>
     * 
     * @return Name of an existing application.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * Version of the application for which you are adding the reference data source. You can use the
     * <a>DescribeApplication</a> operation to get the current application version. If the version specified is not the
     * current version, the <code>ConcurrentModificationException</code> is returned.
     * </p>
     * 
     * @return Version of the application for which you are adding the reference data source. You can use the
     *         <a>DescribeApplication</a> operation to get the current application version. If the version specified is
     *         not the current version, the <code>ConcurrentModificationException</code> is returned.
     */
    public Long currentApplicationVersionId() {
        return currentApplicationVersionId;
    }

    /**
     * <p>
     * The reference data source can be an object in your Amazon S3 bucket. Amazon Kinesis Analytics reads the object
     * and copies the data into the in-application table that is created. You provide an S3 bucket, object key name, and
     * the resulting in-application table that is created. You must also provide an IAM role with the necessary
     * permissions that Amazon Kinesis Analytics can assume to read the object from your S3 bucket on your behalf.
     * </p>
     * 
     * @return The reference data source can be an object in your Amazon S3 bucket. Amazon Kinesis Analytics reads the
     *         object and copies the data into the in-application table that is created. You provide an S3 bucket,
     *         object key name, and the resulting in-application table that is created. You must also provide an IAM
     *         role with the necessary permissions that Amazon Kinesis Analytics can assume to read the object from your
     *         S3 bucket on your behalf.
     */
    public ReferenceDataSource referenceDataSource() {
        return referenceDataSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((applicationName() == null) ? 0 : applicationName().hashCode());
        hashCode = 31 * hashCode + ((currentApplicationVersionId() == null) ? 0 : currentApplicationVersionId().hashCode());
        hashCode = 31 * hashCode + ((referenceDataSource() == null) ? 0 : referenceDataSource().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationReferenceDataSourceRequest)) {
            return false;
        }
        AddApplicationReferenceDataSourceRequest other = (AddApplicationReferenceDataSourceRequest) obj;
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.currentApplicationVersionId() == null ^ this.currentApplicationVersionId() == null) {
            return false;
        }
        if (other.currentApplicationVersionId() != null
                && !other.currentApplicationVersionId().equals(this.currentApplicationVersionId())) {
            return false;
        }
        if (other.referenceDataSource() == null ^ this.referenceDataSource() == null) {
            return false;
        }
        if (other.referenceDataSource() != null && !other.referenceDataSource().equals(this.referenceDataSource())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (applicationName() != null) {
            sb.append("ApplicationName: ").append(applicationName()).append(",");
        }
        if (currentApplicationVersionId() != null) {
            sb.append("CurrentApplicationVersionId: ").append(currentApplicationVersionId()).append(",");
        }
        if (referenceDataSource() != null) {
            sb.append("ReferenceDataSource: ").append(referenceDataSource()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AddApplicationReferenceDataSourceRequest> {
        /**
         * <p>
         * Name of an existing application.
         * </p>
         * 
         * @param applicationName
         *        Name of an existing application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * Version of the application for which you are adding the reference data source. You can use the
         * <a>DescribeApplication</a> operation to get the current application version. If the version specified is not
         * the current version, the <code>ConcurrentModificationException</code> is returned.
         * </p>
         * 
         * @param currentApplicationVersionId
         *        Version of the application for which you are adding the reference data source. You can use the
         *        <a>DescribeApplication</a> operation to get the current application version. If the version specified
         *        is not the current version, the <code>ConcurrentModificationException</code> is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentApplicationVersionId(Long currentApplicationVersionId);

        /**
         * <p>
         * The reference data source can be an object in your Amazon S3 bucket. Amazon Kinesis Analytics reads the
         * object and copies the data into the in-application table that is created. You provide an S3 bucket, object
         * key name, and the resulting in-application table that is created. You must also provide an IAM role with the
         * necessary permissions that Amazon Kinesis Analytics can assume to read the object from your S3 bucket on your
         * behalf.
         * </p>
         * 
         * @param referenceDataSource
         *        The reference data source can be an object in your Amazon S3 bucket. Amazon Kinesis Analytics reads
         *        the object and copies the data into the in-application table that is created. You provide an S3
         *        bucket, object key name, and the resulting in-application table that is created. You must also provide
         *        an IAM role with the necessary permissions that Amazon Kinesis Analytics can assume to read the object
         *        from your S3 bucket on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceDataSource(ReferenceDataSource referenceDataSource);
    }

    private static final class BuilderImpl implements Builder {
        private String applicationName;

        private Long currentApplicationVersionId;

        private ReferenceDataSource referenceDataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(AddApplicationReferenceDataSourceRequest model) {
            setApplicationName(model.applicationName);
            setCurrentApplicationVersionId(model.currentApplicationVersionId);
            setReferenceDataSource(model.referenceDataSource);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Long getCurrentApplicationVersionId() {
            return currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        public final ReferenceDataSource getReferenceDataSource() {
            return referenceDataSource;
        }

        @Override
        public final Builder referenceDataSource(ReferenceDataSource referenceDataSource) {
            this.referenceDataSource = referenceDataSource;
            return this;
        }

        public final void setReferenceDataSource(ReferenceDataSource referenceDataSource) {
            this.referenceDataSource = referenceDataSource;
        }

        @Override
        public AddApplicationReferenceDataSourceRequest build() {
            return new AddApplicationReferenceDataSourceRequest(this);
        }
    }
}
