/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for <code>DescribeStream</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeStreamRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeStreamRequest.Builder, DescribeStreamRequest> {
    private final String streamName;

    private final Integer limit;

    private final String exclusiveStartShardId;

    private DescribeStreamRequest(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.limit = builder.limit;
        this.exclusiveStartShardId = builder.exclusiveStartShardId;
    }

    /**
     * <p>
     * The name of the stream to describe.
     * </p>
     * 
     * @return The name of the stream to describe.
     */
    public String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The maximum number of shards to return in a single call. The default value is 100. If you specify a value greater
     * than 100, at most 100 shards are returned.
     * </p>
     * 
     * @return The maximum number of shards to return in a single call. The default value is 100. If you specify a value
     *         greater than 100, at most 100 shards are returned.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The shard ID of the shard to start with.
     * </p>
     * 
     * @return The shard ID of the shard to start with.
     */
    public String exclusiveStartShardId() {
        return exclusiveStartShardId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((streamName() == null) ? 0 : streamName().hashCode());
        hashCode = 31 * hashCode + ((limit() == null) ? 0 : limit().hashCode());
        hashCode = 31 * hashCode + ((exclusiveStartShardId() == null) ? 0 : exclusiveStartShardId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStreamRequest)) {
            return false;
        }
        DescribeStreamRequest other = (DescribeStreamRequest) obj;
        if (other.streamName() == null ^ this.streamName() == null) {
            return false;
        }
        if (other.streamName() != null && !other.streamName().equals(this.streamName())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.exclusiveStartShardId() == null ^ this.exclusiveStartShardId() == null) {
            return false;
        }
        if (other.exclusiveStartShardId() != null && !other.exclusiveStartShardId().equals(this.exclusiveStartShardId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (streamName() != null) {
            sb.append("StreamName: ").append(streamName()).append(",");
        }
        if (limit() != null) {
            sb.append("Limit: ").append(limit()).append(",");
        }
        if (exclusiveStartShardId() != null) {
            sb.append("ExclusiveStartShardId: ").append(exclusiveStartShardId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeStreamRequest> {
        /**
         * <p>
         * The name of the stream to describe.
         * </p>
         * 
         * @param streamName
         *        The name of the stream to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The maximum number of shards to return in a single call. The default value is 100. If you specify a value
         * greater than 100, at most 100 shards are returned.
         * </p>
         * 
         * @param limit
         *        The maximum number of shards to return in a single call. The default value is 100. If you specify a
         *        value greater than 100, at most 100 shards are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The shard ID of the shard to start with.
         * </p>
         * 
         * @param exclusiveStartShardId
         *        The shard ID of the shard to start with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveStartShardId(String exclusiveStartShardId);
    }

    private static final class BuilderImpl implements Builder {
        private String streamName;

        private Integer limit;

        private String exclusiveStartShardId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStreamRequest model) {
            setStreamName(model.streamName);
            setLimit(model.limit);
            setExclusiveStartShardId(model.exclusiveStartShardId);
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getExclusiveStartShardId() {
            return exclusiveStartShardId;
        }

        @Override
        public final Builder exclusiveStartShardId(String exclusiveStartShardId) {
            this.exclusiveStartShardId = exclusiveStartShardId;
            return this;
        }

        public final void setExclusiveStartShardId(String exclusiveStartShardId) {
            this.exclusiveStartShardId = exclusiveStartShardId;
        }

        @Override
        public DescribeStreamRequest build() {
            return new DescribeStreamRequest(this);
        }
    }
}
