/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeLimitsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeLimitsResponse.Builder, DescribeLimitsResponse> {
    private final Integer shardLimit;

    private final Integer openShardCount;

    private DescribeLimitsResponse(BuilderImpl builder) {
        this.shardLimit = builder.shardLimit;
        this.openShardCount = builder.openShardCount;
    }

    /**
     * <p>
     * The maximum number of shards.
     * </p>
     * 
     * @return The maximum number of shards.
     */
    public Integer shardLimit() {
        return shardLimit;
    }

    /**
     * <p>
     * The number of open shards.
     * </p>
     * 
     * @return The number of open shards.
     */
    public Integer openShardCount() {
        return openShardCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((shardLimit() == null) ? 0 : shardLimit().hashCode());
        hashCode = 31 * hashCode + ((openShardCount() == null) ? 0 : openShardCount().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLimitsResponse)) {
            return false;
        }
        DescribeLimitsResponse other = (DescribeLimitsResponse) obj;
        if (other.shardLimit() == null ^ this.shardLimit() == null) {
            return false;
        }
        if (other.shardLimit() != null && !other.shardLimit().equals(this.shardLimit())) {
            return false;
        }
        if (other.openShardCount() == null ^ this.openShardCount() == null) {
            return false;
        }
        if (other.openShardCount() != null && !other.openShardCount().equals(this.openShardCount())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (shardLimit() != null) {
            sb.append("ShardLimit: ").append(shardLimit()).append(",");
        }
        if (openShardCount() != null) {
            sb.append("OpenShardCount: ").append(openShardCount()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeLimitsResponse> {
        /**
         * <p>
         * The maximum number of shards.
         * </p>
         * 
         * @param shardLimit
         *        The maximum number of shards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardLimit(Integer shardLimit);

        /**
         * <p>
         * The number of open shards.
         * </p>
         * 
         * @param openShardCount
         *        The number of open shards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openShardCount(Integer openShardCount);
    }

    private static final class BuilderImpl implements Builder {
        private Integer shardLimit;

        private Integer openShardCount;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLimitsResponse model) {
            setShardLimit(model.shardLimit);
            setOpenShardCount(model.openShardCount);
        }

        public final Integer getShardLimit() {
            return shardLimit;
        }

        @Override
        public final Builder shardLimit(Integer shardLimit) {
            this.shardLimit = shardLimit;
            return this;
        }

        public final void setShardLimit(Integer shardLimit) {
            this.shardLimit = shardLimit;
        }

        public final Integer getOpenShardCount() {
            return openShardCount;
        }

        @Override
        public final Builder openShardCount(Integer openShardCount) {
            this.openShardCount = openShardCount;
            return this;
        }

        public final void setOpenShardCount(Integer openShardCount) {
            this.openShardCount = openShardCount;
        }

        @Override
        public DescribeLimitsResponse build() {
            return new DescribeLimitsResponse(this);
        }
    }
}
