/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.firehose.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * CopyCommand JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CopyCommandUnmarshaller implements Unmarshaller<CopyCommand, JsonUnmarshallerContext> {

    public CopyCommand unmarshall(JsonUnmarshallerContext context) throws Exception {
        CopyCommand.Builder copyCommandBuilder = CopyCommand.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("DataTableName", targetDepth)) {
                    context.nextToken();
                    copyCommandBuilder.dataTableName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DataTableColumns", targetDepth)) {
                    context.nextToken();
                    copyCommandBuilder.dataTableColumns(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CopyOptions", targetDepth)) {
                    context.nextToken();
                    copyCommandBuilder.copyOptions(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return copyCommandBuilder.build();
    }

    private static final CopyCommandUnmarshaller INSTANCE = new CopyCommandUnmarshaller();

    public static CopyCommandUnmarshaller getInstance() {
        return INSTANCE;
    }
}
