/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceDescription;

@SdkInternalApi
public class ReferenceDataSourceDescriptionMarshaller {
    private static final MarshallingInfo<String> REFERENCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReferenceId").build();
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").build();
    private static final MarshallingInfo<StructuredPojo> S3REFERENCEDATASOURCEDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3ReferenceDataSourceDescription").build();
    private static final MarshallingInfo<StructuredPojo> REFERENCESCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReferenceSchema").build();
    private static final ReferenceDataSourceDescriptionMarshaller INSTANCE = new ReferenceDataSourceDescriptionMarshaller();

    public static ReferenceDataSourceDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReferenceDataSourceDescription referenceDataSourceDescription, ProtocolMarshaller protocolMarshaller) {
        if (referenceDataSourceDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)referenceDataSourceDescription.referenceId(), REFERENCEID_BINDING);
            protocolMarshaller.marshall((Object)referenceDataSourceDescription.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall((Object)referenceDataSourceDescription.s3ReferenceDataSourceDescription(), S3REFERENCEDATASOURCEDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)referenceDataSourceDescription.referenceSchema(), REFERENCESCHEMA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

