/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.kinesis.model.EnhancedMetrics;

public class EnhancedMetricsUnmarshaller
implements Unmarshaller<EnhancedMetrics, JsonUnmarshallerContext> {
    private static final EnhancedMetricsUnmarshaller INSTANCE = new EnhancedMetricsUnmarshaller();

    public EnhancedMetrics unmarshall(JsonUnmarshallerContext context) throws Exception {
        EnhancedMetrics.Builder enhancedMetricsBuilder = EnhancedMetrics.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ShardLevelMetrics", targetDepth)) {
                    context.nextToken();
                    enhancedMetricsBuilder.shardLevelMetrics(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (EnhancedMetrics)enhancedMetricsBuilder.build();
    }

    public static EnhancedMetricsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

