/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.firehose.model.ProcessorParameter;

@SdkInternalApi
public class ProcessorParameterMarshaller {
    private static final MarshallingInfo<String> PARAMETERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterName").build();
    private static final MarshallingInfo<String> PARAMETERVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterValue").build();
    private static final ProcessorParameterMarshaller INSTANCE = new ProcessorParameterMarshaller();

    public static ProcessorParameterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProcessorParameter processorParameter, ProtocolMarshaller protocolMarshaller) {
        if (processorParameter == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)processorParameter.parameterName(), PARAMETERNAME_BINDING);
            protocolMarshaller.marshall((Object)processorParameter.parameterValue(), PARAMETERVALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

