/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;

@SdkInternalApi
public class CloudWatchLoggingOptionsMarshaller {
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").build();
    private static final MarshallingInfo<String> LOGGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogGroupName").build();
    private static final MarshallingInfo<String> LOGSTREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogStreamName").build();
    private static final CloudWatchLoggingOptionsMarshaller INSTANCE = new CloudWatchLoggingOptionsMarshaller();

    public static CloudWatchLoggingOptionsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CloudWatchLoggingOptions cloudWatchLoggingOptions, ProtocolMarshaller protocolMarshaller) {
        if (cloudWatchLoggingOptions == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cloudWatchLoggingOptions.enabled(), ENABLED_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchLoggingOptions.logGroupName(), LOGGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchLoggingOptions.logStreamName(), LOGSTREAMNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

