/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDeliveryStreamRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeDeliveryStreamRequest> {
    private final String deliveryStreamName;
    private final Integer limit;
    private final String exclusiveStartDestinationId;

    private DescribeDeliveryStreamRequest(BuilderImpl builder) {
        this.deliveryStreamName = builder.deliveryStreamName;
        this.limit = builder.limit;
        this.exclusiveStartDestinationId = builder.exclusiveStartDestinationId;
    }

    public String deliveryStreamName() {
        return this.deliveryStreamName;
    }

    public Integer limit() {
        return this.limit;
    }

    public String exclusiveStartDestinationId() {
        return this.exclusiveStartDestinationId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deliveryStreamName() == null ? 0 : this.deliveryStreamName().hashCode());
        hashCode = 31 * hashCode + (this.limit() == null ? 0 : this.limit().hashCode());
        hashCode = 31 * hashCode + (this.exclusiveStartDestinationId() == null ? 0 : this.exclusiveStartDestinationId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeliveryStreamRequest)) {
            return false;
        }
        DescribeDeliveryStreamRequest other = (DescribeDeliveryStreamRequest)((Object)obj);
        if (other.deliveryStreamName() == null ^ this.deliveryStreamName() == null) {
            return false;
        }
        if (other.deliveryStreamName() != null && !other.deliveryStreamName().equals(this.deliveryStreamName())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.exclusiveStartDestinationId() == null ^ this.exclusiveStartDestinationId() == null) {
            return false;
        }
        return other.exclusiveStartDestinationId() == null || other.exclusiveStartDestinationId().equals(this.exclusiveStartDestinationId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deliveryStreamName() != null) {
            sb.append("DeliveryStreamName: ").append(this.deliveryStreamName()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.exclusiveStartDestinationId() != null) {
            sb.append("ExclusiveStartDestinationId: ").append(this.exclusiveStartDestinationId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String deliveryStreamName;
        private Integer limit;
        private String exclusiveStartDestinationId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeliveryStreamRequest model) {
            this.setDeliveryStreamName(model.deliveryStreamName);
            this.setLimit(model.limit);
            this.setExclusiveStartDestinationId(model.exclusiveStartDestinationId);
        }

        public final String getDeliveryStreamName() {
            return this.deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getExclusiveStartDestinationId() {
            return this.exclusiveStartDestinationId;
        }

        @Override
        public final Builder exclusiveStartDestinationId(String exclusiveStartDestinationId) {
            this.exclusiveStartDestinationId = exclusiveStartDestinationId;
            return this;
        }

        public final void setExclusiveStartDestinationId(String exclusiveStartDestinationId) {
            this.exclusiveStartDestinationId = exclusiveStartDestinationId;
        }

        public DescribeDeliveryStreamRequest build() {
            return new DescribeDeliveryStreamRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeDeliveryStreamRequest> {
        public Builder deliveryStreamName(String var1);

        public Builder limit(Integer var1);

        public Builder exclusiveStartDestinationId(String var1);
    }
}

