/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeApplicationResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeApplicationResponse.Builder, DescribeApplicationResponse> {
    private final ApplicationDetail applicationDetail;

    private DescribeApplicationResponse(BuilderImpl builder) {
        this.applicationDetail = builder.applicationDetail;
    }

    /**
     * <p>
     * Provides a description of the application, such as the application Amazon Resource Name (ARN), status, latest
     * version, and input and output configuration details.
     * </p>
     * 
     * @return Provides a description of the application, such as the application Amazon Resource Name (ARN), status,
     *         latest version, and input and output configuration details.
     */
    public ApplicationDetail applicationDetail() {
        return applicationDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((applicationDetail() == null) ? 0 : applicationDetail().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationResponse)) {
            return false;
        }
        DescribeApplicationResponse other = (DescribeApplicationResponse) obj;
        if (other.applicationDetail() == null ^ this.applicationDetail() == null) {
            return false;
        }
        if (other.applicationDetail() != null && !other.applicationDetail().equals(this.applicationDetail())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (applicationDetail() != null) {
            sb.append("ApplicationDetail: ").append(applicationDetail()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeApplicationResponse> {
        /**
         * <p>
         * Provides a description of the application, such as the application Amazon Resource Name (ARN), status, latest
         * version, and input and output configuration details.
         * </p>
         * 
         * @param applicationDetail
         *        Provides a description of the application, such as the application Amazon Resource Name (ARN), status,
         *        latest version, and input and output configuration details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationDetail(ApplicationDetail applicationDetail);
    }

    private static final class BuilderImpl implements Builder {
        private ApplicationDetail applicationDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationResponse model) {
            setApplicationDetail(model.applicationDetail);
        }

        public final ApplicationDetail getApplicationDetail() {
            return applicationDetail;
        }

        @Override
        public final Builder applicationDetail(ApplicationDetail applicationDetail) {
            this.applicationDetail = applicationDetail;
            return this;
        }

        public final void setApplicationDetail(ApplicationDetail applicationDetail) {
            this.applicationDetail = applicationDetail;
        }

        @Override
        public DescribeApplicationResponse build() {
            return new DescribeApplicationResponse(this);
        }
    }
}
