/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateShardCountRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateShardCountRequest.Builder, UpdateShardCountRequest> {
    private final String streamName;

    private final Integer targetShardCount;

    private final String scalingType;

    private UpdateShardCountRequest(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.targetShardCount = builder.targetShardCount;
        this.scalingType = builder.scalingType;
    }

    /**
     * <p>
     * The name of the stream.
     * </p>
     * 
     * @return The name of the stream.
     */
    public String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The new number of shards.
     * </p>
     * 
     * @return The new number of shards.
     */
    public Integer targetShardCount() {
        return targetShardCount;
    }

    /**
     * <p>
     * The scaling type. Uniform scaling creates shards of equal size.
     * </p>
     * 
     * @return The scaling type. Uniform scaling creates shards of equal size.
     * @see ScalingType
     */
    public String scalingType() {
        return scalingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((streamName() == null) ? 0 : streamName().hashCode());
        hashCode = 31 * hashCode + ((targetShardCount() == null) ? 0 : targetShardCount().hashCode());
        hashCode = 31 * hashCode + ((scalingType() == null) ? 0 : scalingType().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateShardCountRequest)) {
            return false;
        }
        UpdateShardCountRequest other = (UpdateShardCountRequest) obj;
        if (other.streamName() == null ^ this.streamName() == null) {
            return false;
        }
        if (other.streamName() != null && !other.streamName().equals(this.streamName())) {
            return false;
        }
        if (other.targetShardCount() == null ^ this.targetShardCount() == null) {
            return false;
        }
        if (other.targetShardCount() != null && !other.targetShardCount().equals(this.targetShardCount())) {
            return false;
        }
        if (other.scalingType() == null ^ this.scalingType() == null) {
            return false;
        }
        if (other.scalingType() != null && !other.scalingType().equals(this.scalingType())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (streamName() != null) {
            sb.append("StreamName: ").append(streamName()).append(",");
        }
        if (targetShardCount() != null) {
            sb.append("TargetShardCount: ").append(targetShardCount()).append(",");
        }
        if (scalingType() != null) {
            sb.append("ScalingType: ").append(scalingType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateShardCountRequest> {
        /**
         * <p>
         * The name of the stream.
         * </p>
         * 
         * @param streamName
         *        The name of the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The new number of shards.
         * </p>
         * 
         * @param targetShardCount
         *        The new number of shards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetShardCount(Integer targetShardCount);

        /**
         * <p>
         * The scaling type. Uniform scaling creates shards of equal size.
         * </p>
         * 
         * @param scalingType
         *        The scaling type. Uniform scaling creates shards of equal size.
         * @see ScalingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalingType
         */
        Builder scalingType(String scalingType);

        /**
         * <p>
         * The scaling type. Uniform scaling creates shards of equal size.
         * </p>
         * 
         * @param scalingType
         *        The scaling type. Uniform scaling creates shards of equal size.
         * @see ScalingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalingType
         */
        Builder scalingType(ScalingType scalingType);
    }

    private static final class BuilderImpl implements Builder {
        private String streamName;

        private Integer targetShardCount;

        private String scalingType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateShardCountRequest model) {
            setStreamName(model.streamName);
            setTargetShardCount(model.targetShardCount);
            setScalingType(model.scalingType);
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Integer getTargetShardCount() {
            return targetShardCount;
        }

        @Override
        public final Builder targetShardCount(Integer targetShardCount) {
            this.targetShardCount = targetShardCount;
            return this;
        }

        public final void setTargetShardCount(Integer targetShardCount) {
            this.targetShardCount = targetShardCount;
        }

        public final String getScalingType() {
            return scalingType;
        }

        @Override
        public final Builder scalingType(String scalingType) {
            this.scalingType = scalingType;
            return this;
        }

        @Override
        public final Builder scalingType(ScalingType scalingType) {
            this.scalingType(scalingType.toString());
            return this;
        }

        public final void setScalingType(String scalingType) {
            this.scalingType = scalingType;
        }

        @Override
        public UpdateShardCountRequest build() {
            return new UpdateShardCountRequest(this);
        }
    }
}
