/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.firehose.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * RedshiftDestinationDescription JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class RedshiftDestinationDescriptionUnmarshaller implements
        Unmarshaller<RedshiftDestinationDescription, JsonUnmarshallerContext> {

    public RedshiftDestinationDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        RedshiftDestinationDescription.Builder redshiftDestinationDescriptionBuilder = RedshiftDestinationDescription.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("RoleARN", targetDepth)) {
                    context.nextToken();
                    redshiftDestinationDescriptionBuilder.roleARN(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ClusterJDBCURL", targetDepth)) {
                    context.nextToken();
                    redshiftDestinationDescriptionBuilder.clusterJDBCURL(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("CopyCommand", targetDepth)) {
                    context.nextToken();
                    redshiftDestinationDescriptionBuilder.copyCommand(CopyCommandUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Username", targetDepth)) {
                    context.nextToken();
                    redshiftDestinationDescriptionBuilder.username(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("RetryOptions", targetDepth)) {
                    context.nextToken();
                    redshiftDestinationDescriptionBuilder.retryOptions(RedshiftRetryOptionsUnmarshaller.getInstance().unmarshall(
                            context));
                }
                if (context.testExpression("S3DestinationDescription", targetDepth)) {
                    context.nextToken();
                    redshiftDestinationDescriptionBuilder.s3DestinationDescription(S3DestinationDescriptionUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("ProcessingConfiguration", targetDepth)) {
                    context.nextToken();
                    redshiftDestinationDescriptionBuilder.processingConfiguration(ProcessingConfigurationUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("S3BackupMode", targetDepth)) {
                    context.nextToken();
                    redshiftDestinationDescriptionBuilder.s3BackupMode(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("S3BackupDescription", targetDepth)) {
                    context.nextToken();
                    redshiftDestinationDescriptionBuilder.s3BackupDescription(S3DestinationDescriptionUnmarshaller.getInstance()
                            .unmarshall(context));
                }
                if (context.testExpression("CloudWatchLoggingOptions", targetDepth)) {
                    context.nextToken();
                    redshiftDestinationDescriptionBuilder.cloudWatchLoggingOptions(CloudWatchLoggingOptionsUnmarshaller
                            .getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return redshiftDestinationDescriptionBuilder.build();
    }

    private static final RedshiftDestinationDescriptionUnmarshaller INSTANCE = new RedshiftDestinationDescriptionUnmarshaller();

    public static RedshiftDestinationDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}
