/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.S3DestinationUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an update for a destination in Amazon S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class S3DestinationUpdate implements StructuredPojo, ToCopyableBuilder<S3DestinationUpdate.Builder, S3DestinationUpdate> {
    private final String roleARN;

    private final String bucketARN;

    private final String prefix;

    private final BufferingHints bufferingHints;

    private final String compressionFormat;

    private final EncryptionConfiguration encryptionConfiguration;

    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;

    private S3DestinationUpdate(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.bucketARN = builder.bucketARN;
        this.prefix = builder.prefix;
        this.bufferingHints = builder.bufferingHints;
        this.compressionFormat = builder.compressionFormat;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
    }

    /**
     * <p>
     * The ARN of the AWS credentials.
     * </p>
     * 
     * @return The ARN of the AWS credentials.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The ARN of the S3 bucket.
     * </p>
     * 
     * @return The ARN of the S3 bucket.
     */
    public String bucketARN() {
        return bucketARN;
    }

    /**
     * <p>
     * The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered S3 files. You can specify an extra
     * prefix to be added in front of the time format prefix. Note that if the prefix ends with a slash, it appears as a
     * folder in the S3 bucket. For more information, see <a
     * href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html">Amazon S3 Object Name Format</a> in the
     * <i>Amazon Kinesis Firehose Developer Guide</i>.
     * </p>
     * 
     * @return The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered S3 files. You can specify an
     *         extra prefix to be added in front of the time format prefix. Note that if the prefix ends with a slash,
     *         it appears as a folder in the S3 bucket. For more information, see <a
     *         href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html">Amazon S3 Object Name Format</a>
     *         in the <i>Amazon Kinesis Firehose Developer Guide</i>.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * <p>
     * The buffering option. If no value is specified, <b>BufferingHints</b> object default values are used.
     * </p>
     * 
     * @return The buffering option. If no value is specified, <b>BufferingHints</b> object default values are used.
     */
    public BufferingHints bufferingHints() {
        return bufferingHints;
    }

    /**
     * <p>
     * The compression format. If no value is specified, the default is <code>UNCOMPRESSED</code>.
     * </p>
     * <p>
     * The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified for Amazon Redshift
     * destinations because they are not supported by the Amazon Redshift <code>COPY</code> operation that reads from
     * the S3 bucket.
     * </p>
     * 
     * @return The compression format. If no value is specified, the default is <code>UNCOMPRESSED</code>.</p>
     *         <p>
     *         The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified for Amazon Redshift
     *         destinations because they are not supported by the Amazon Redshift <code>COPY</code> operation that reads
     *         from the S3 bucket.
     * @see CompressionFormat
     */
    public String compressionFormat() {
        return compressionFormat;
    }

    /**
     * <p>
     * The encryption configuration. If no value is specified, the default is no encryption.
     * </p>
     * 
     * @return The encryption configuration. If no value is specified, the default is no encryption.
     */
    public EncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    /**
     * <p>
     * The CloudWatch logging options for your delivery stream.
     * </p>
     * 
     * @return The CloudWatch logging options for your delivery stream.
     */
    public CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return cloudWatchLoggingOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((roleARN() == null) ? 0 : roleARN().hashCode());
        hashCode = 31 * hashCode + ((bucketARN() == null) ? 0 : bucketARN().hashCode());
        hashCode = 31 * hashCode + ((prefix() == null) ? 0 : prefix().hashCode());
        hashCode = 31 * hashCode + ((bufferingHints() == null) ? 0 : bufferingHints().hashCode());
        hashCode = 31 * hashCode + ((compressionFormat() == null) ? 0 : compressionFormat().hashCode());
        hashCode = 31 * hashCode + ((encryptionConfiguration() == null) ? 0 : encryptionConfiguration().hashCode());
        hashCode = 31 * hashCode + ((cloudWatchLoggingOptions() == null) ? 0 : cloudWatchLoggingOptions().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DestinationUpdate)) {
            return false;
        }
        S3DestinationUpdate other = (S3DestinationUpdate) obj;
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.bucketARN() == null ^ this.bucketARN() == null) {
            return false;
        }
        if (other.bucketARN() != null && !other.bucketARN().equals(this.bucketARN())) {
            return false;
        }
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        if (other.bufferingHints() == null ^ this.bufferingHints() == null) {
            return false;
        }
        if (other.bufferingHints() != null && !other.bufferingHints().equals(this.bufferingHints())) {
            return false;
        }
        if (other.compressionFormat() == null ^ this.compressionFormat() == null) {
            return false;
        }
        if (other.compressionFormat() != null && !other.compressionFormat().equals(this.compressionFormat())) {
            return false;
        }
        if (other.encryptionConfiguration() == null ^ this.encryptionConfiguration() == null) {
            return false;
        }
        if (other.encryptionConfiguration() != null && !other.encryptionConfiguration().equals(this.encryptionConfiguration())) {
            return false;
        }
        if (other.cloudWatchLoggingOptions() == null ^ this.cloudWatchLoggingOptions() == null) {
            return false;
        }
        if (other.cloudWatchLoggingOptions() != null && !other.cloudWatchLoggingOptions().equals(this.cloudWatchLoggingOptions())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (roleARN() != null) {
            sb.append("RoleARN: ").append(roleARN()).append(",");
        }
        if (bucketARN() != null) {
            sb.append("BucketARN: ").append(bucketARN()).append(",");
        }
        if (prefix() != null) {
            sb.append("Prefix: ").append(prefix()).append(",");
        }
        if (bufferingHints() != null) {
            sb.append("BufferingHints: ").append(bufferingHints()).append(",");
        }
        if (compressionFormat() != null) {
            sb.append("CompressionFormat: ").append(compressionFormat()).append(",");
        }
        if (encryptionConfiguration() != null) {
            sb.append("EncryptionConfiguration: ").append(encryptionConfiguration()).append(",");
        }
        if (cloudWatchLoggingOptions() != null) {
            sb.append("CloudWatchLoggingOptions: ").append(cloudWatchLoggingOptions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3DestinationUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, S3DestinationUpdate> {
        /**
         * <p>
         * The ARN of the AWS credentials.
         * </p>
         * 
         * @param roleARN
         *        The ARN of the AWS credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The ARN of the S3 bucket.
         * </p>
         * 
         * @param bucketARN
         *        The ARN of the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketARN(String bucketARN);

        /**
         * <p>
         * The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered S3 files. You can specify an extra
         * prefix to be added in front of the time format prefix. Note that if the prefix ends with a slash, it appears
         * as a folder in the S3 bucket. For more information, see <a
         * href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html">Amazon S3 Object Name Format</a> in
         * the <i>Amazon Kinesis Firehose Developer Guide</i>.
         * </p>
         * 
         * @param prefix
         *        The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered S3 files. You can specify
         *        an extra prefix to be added in front of the time format prefix. Note that if the prefix ends with a
         *        slash, it appears as a folder in the S3 bucket. For more information, see <a
         *        href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html">Amazon S3 Object Name
         *        Format</a> in the <i>Amazon Kinesis Firehose Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * The buffering option. If no value is specified, <b>BufferingHints</b> object default values are used.
         * </p>
         * 
         * @param bufferingHints
         *        The buffering option. If no value is specified, <b>BufferingHints</b> object default values are used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bufferingHints(BufferingHints bufferingHints);

        /**
         * <p>
         * The compression format. If no value is specified, the default is <code>UNCOMPRESSED</code>.
         * </p>
         * <p>
         * The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified for Amazon Redshift
         * destinations because they are not supported by the Amazon Redshift <code>COPY</code> operation that reads
         * from the S3 bucket.
         * </p>
         * 
         * @param compressionFormat
         *        The compression format. If no value is specified, the default is <code>UNCOMPRESSED</code>.</p>
         *        <p>
         *        The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified for Amazon
         *        Redshift destinations because they are not supported by the Amazon Redshift <code>COPY</code>
         *        operation that reads from the S3 bucket.
         * @see CompressionFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompressionFormat
         */
        Builder compressionFormat(String compressionFormat);

        /**
         * <p>
         * The compression format. If no value is specified, the default is <code>UNCOMPRESSED</code>.
         * </p>
         * <p>
         * The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified for Amazon Redshift
         * destinations because they are not supported by the Amazon Redshift <code>COPY</code> operation that reads
         * from the S3 bucket.
         * </p>
         * 
         * @param compressionFormat
         *        The compression format. If no value is specified, the default is <code>UNCOMPRESSED</code>.</p>
         *        <p>
         *        The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified for Amazon
         *        Redshift destinations because they are not supported by the Amazon Redshift <code>COPY</code>
         *        operation that reads from the S3 bucket.
         * @see CompressionFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompressionFormat
         */
        Builder compressionFormat(CompressionFormat compressionFormat);

        /**
         * <p>
         * The encryption configuration. If no value is specified, the default is no encryption.
         * </p>
         * 
         * @param encryptionConfiguration
         *        The encryption configuration. If no value is specified, the default is no encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration);

        /**
         * <p>
         * The CloudWatch logging options for your delivery stream.
         * </p>
         * 
         * @param cloudWatchLoggingOptions
         *        The CloudWatch logging options for your delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions);
    }

    private static final class BuilderImpl implements Builder {
        private String roleARN;

        private String bucketARN;

        private String prefix;

        private BufferingHints bufferingHints;

        private String compressionFormat;

        private EncryptionConfiguration encryptionConfiguration;

        private CloudWatchLoggingOptions cloudWatchLoggingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(S3DestinationUpdate model) {
            setRoleARN(model.roleARN);
            setBucketARN(model.bucketARN);
            setPrefix(model.prefix);
            setBufferingHints(model.bufferingHints);
            setCompressionFormat(model.compressionFormat);
            setEncryptionConfiguration(model.encryptionConfiguration);
            setCloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getBucketARN() {
            return bucketARN;
        }

        @Override
        public final Builder bucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
            return this;
        }

        public final void setBucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final BufferingHints getBufferingHints() {
            return bufferingHints;
        }

        @Override
        public final Builder bufferingHints(BufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final void setBufferingHints(BufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
        }

        public final String getCompressionFormat() {
            return compressionFormat;
        }

        @Override
        public final Builder compressionFormat(String compressionFormat) {
            this.compressionFormat = compressionFormat;
            return this;
        }

        @Override
        public final Builder compressionFormat(CompressionFormat compressionFormat) {
            this.compressionFormat(compressionFormat.toString());
            return this;
        }

        public final void setCompressionFormat(String compressionFormat) {
            this.compressionFormat = compressionFormat;
        }

        public final EncryptionConfiguration getEncryptionConfiguration() {
            return encryptionConfiguration;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
        }

        public final CloudWatchLoggingOptions getCloudWatchLoggingOptions() {
            return cloudWatchLoggingOptions;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
        }

        @Override
        public S3DestinationUpdate build() {
            return new S3DestinationUpdate(this);
        }
    }
}
