/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutRecordBatchResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<PutRecordBatchResponse.Builder, PutRecordBatchResponse> {
    private final Integer failedPutCount;

    private final List<PutRecordBatchResponseEntry> requestResponses;

    private PutRecordBatchResponse(BuilderImpl builder) {
        this.failedPutCount = builder.failedPutCount;
        this.requestResponses = builder.requestResponses;
    }

    /**
     * <p>
     * The number of records that might have failed processing.
     * </p>
     * 
     * @return The number of records that might have failed processing.
     */
    public Integer failedPutCount() {
        return failedPutCount;
    }

    /**
     * <p>
     * The results array. For each record, the index of the response element is the same as the index used in the
     * request array.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The results array. For each record, the index of the response element is the same as the index used in
     *         the request array.
     */
    public List<PutRecordBatchResponseEntry> requestResponses() {
        return requestResponses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((failedPutCount() == null) ? 0 : failedPutCount().hashCode());
        hashCode = 31 * hashCode + ((requestResponses() == null) ? 0 : requestResponses().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordBatchResponse)) {
            return false;
        }
        PutRecordBatchResponse other = (PutRecordBatchResponse) obj;
        if (other.failedPutCount() == null ^ this.failedPutCount() == null) {
            return false;
        }
        if (other.failedPutCount() != null && !other.failedPutCount().equals(this.failedPutCount())) {
            return false;
        }
        if (other.requestResponses() == null ^ this.requestResponses() == null) {
            return false;
        }
        if (other.requestResponses() != null && !other.requestResponses().equals(this.requestResponses())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (failedPutCount() != null) {
            sb.append("FailedPutCount: ").append(failedPutCount()).append(",");
        }
        if (requestResponses() != null) {
            sb.append("RequestResponses: ").append(requestResponses()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PutRecordBatchResponse> {
        /**
         * <p>
         * The number of records that might have failed processing.
         * </p>
         * 
         * @param failedPutCount
         *        The number of records that might have failed processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedPutCount(Integer failedPutCount);

        /**
         * <p>
         * The results array. For each record, the index of the response element is the same as the index used in the
         * request array.
         * </p>
         * 
         * @param requestResponses
         *        The results array. For each record, the index of the response element is the same as the index used in
         *        the request array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestResponses(Collection<PutRecordBatchResponseEntry> requestResponses);

        /**
         * <p>
         * The results array. For each record, the index of the response element is the same as the index used in the
         * request array.
         * </p>
         * 
         * @param requestResponses
         *        The results array. For each record, the index of the response element is the same as the index used in
         *        the request array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestResponses(PutRecordBatchResponseEntry... requestResponses);
    }

    private static final class BuilderImpl implements Builder {
        private Integer failedPutCount;

        private List<PutRecordBatchResponseEntry> requestResponses;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordBatchResponse model) {
            setFailedPutCount(model.failedPutCount);
            setRequestResponses(model.requestResponses);
        }

        public final Integer getFailedPutCount() {
            return failedPutCount;
        }

        @Override
        public final Builder failedPutCount(Integer failedPutCount) {
            this.failedPutCount = failedPutCount;
            return this;
        }

        public final void setFailedPutCount(Integer failedPutCount) {
            this.failedPutCount = failedPutCount;
        }

        public final Collection<PutRecordBatchResponseEntry> getRequestResponses() {
            return requestResponses;
        }

        @Override
        public final Builder requestResponses(Collection<PutRecordBatchResponseEntry> requestResponses) {
            this.requestResponses = PutRecordBatchResponseEntryListCopier.copy(requestResponses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestResponses(PutRecordBatchResponseEntry... requestResponses) {
            requestResponses(Arrays.asList(requestResponses));
            return this;
        }

        public final void setRequestResponses(Collection<PutRecordBatchResponseEntry> requestResponses) {
            this.requestResponses = PutRecordBatchResponseEntryListCopier.copy(requestResponses);
        }

        @Override
        public PutRecordBatchResponse build() {
            return new PutRecordBatchResponse(this);
        }
    }
}
