/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.ElasticsearchDestinationUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an update for a destination in Amazon ES.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ElasticsearchDestinationUpdate implements StructuredPojo,
        ToCopyableBuilder<ElasticsearchDestinationUpdate.Builder, ElasticsearchDestinationUpdate> {
    private final String roleARN;

    private final String domainARN;

    private final String indexName;

    private final String typeName;

    private final String indexRotationPeriod;

    private final ElasticsearchBufferingHints bufferingHints;

    private final ElasticsearchRetryOptions retryOptions;

    private final S3DestinationUpdate s3Update;

    private final ProcessingConfiguration processingConfiguration;

    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;

    private ElasticsearchDestinationUpdate(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.domainARN = builder.domainARN;
        this.indexName = builder.indexName;
        this.typeName = builder.typeName;
        this.indexRotationPeriod = builder.indexRotationPeriod;
        this.bufferingHints = builder.bufferingHints;
        this.retryOptions = builder.retryOptions;
        this.s3Update = builder.s3Update;
        this.processingConfiguration = builder.processingConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
    }

    /**
     * <p>
     * The ARN of the IAM role to be assumed by Firehose for calling the Amazon ES Configuration API and for indexing
     * documents. For more information, see <a
     * href="http://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Amazon S3 Bucket
     * Access</a>.
     * </p>
     * 
     * @return The ARN of the IAM role to be assumed by Firehose for calling the Amazon ES Configuration API and for
     *         indexing documents. For more information, see <a
     *         href="http://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Amazon S3
     *         Bucket Access</a>.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The ARN of the Amazon ES domain. The IAM role must have permissions for <code>DescribeElasticsearchDomain</code>,
     * <code>DescribeElasticsearchDomains</code>, and <code>DescribeElasticsearchDomainConfig</code> after assuming the
     * IAM role specified in <b>RoleARN</b>.
     * </p>
     * 
     * @return The ARN of the Amazon ES domain. The IAM role must have permissions for 
     *         <code>DescribeElasticsearchDomain</code>, <code>DescribeElasticsearchDomains</code>, and
     *         <code>DescribeElasticsearchDomainConfig</code> after assuming the IAM role specified in <b>RoleARN</b>.
     */
    public String domainARN() {
        return domainARN;
    }

    /**
     * <p>
     * The Elasticsearch index name.
     * </p>
     * 
     * @return The Elasticsearch index name.
     */
    public String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The Elasticsearch type name.
     * </p>
     * 
     * @return The Elasticsearch type name.
     */
    public String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The Elasticsearch index rotation period. Index rotation appends a timestamp to IndexName to facilitate the
     * expiration of old data. For more information, see <a
     * href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation for
     * Amazon Elasticsearch Service Destination</a>. Default value is <code>OneDay</code>.
     * </p>
     * 
     * @return The Elasticsearch index rotation period. Index rotation appends a timestamp to IndexName to facilitate
     *         the expiration of old data. For more information, see <a
     *         href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation
     *         for Amazon Elasticsearch Service Destination</a>. Default value is <code>OneDay</code>.
     * @see ElasticsearchIndexRotationPeriod
     */
    public String indexRotationPeriod() {
        return indexRotationPeriod;
    }

    /**
     * <p>
     * The buffering options. If no value is specified, <b>ElasticsearchBufferingHints</b> object default values are
     * used.
     * </p>
     * 
     * @return The buffering options. If no value is specified, <b>ElasticsearchBufferingHints</b> object default values
     *         are used.
     */
    public ElasticsearchBufferingHints bufferingHints() {
        return bufferingHints;
    }

    /**
     * <p>
     * The retry behavior in the event that Firehose is unable to deliver documents to Amazon ES. Default value is 300
     * (5 minutes).
     * </p>
     * 
     * @return The retry behavior in the event that Firehose is unable to deliver documents to Amazon ES. Default value
     *         is 300 (5 minutes).
     */
    public ElasticsearchRetryOptions retryOptions() {
        return retryOptions;
    }

    /**
     * <p>
     * The Amazon S3 destination.
     * </p>
     * 
     * @return The Amazon S3 destination.
     */
    public S3DestinationUpdate s3Update() {
        return s3Update;
    }

    /**
     * <p>
     * The data processing configuration.
     * </p>
     * 
     * @return The data processing configuration.
     */
    public ProcessingConfiguration processingConfiguration() {
        return processingConfiguration;
    }

    /**
     * <p>
     * The CloudWatch logging options for your delivery stream.
     * </p>
     * 
     * @return The CloudWatch logging options for your delivery stream.
     */
    public CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return cloudWatchLoggingOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((roleARN() == null) ? 0 : roleARN().hashCode());
        hashCode = 31 * hashCode + ((domainARN() == null) ? 0 : domainARN().hashCode());
        hashCode = 31 * hashCode + ((indexName() == null) ? 0 : indexName().hashCode());
        hashCode = 31 * hashCode + ((typeName() == null) ? 0 : typeName().hashCode());
        hashCode = 31 * hashCode + ((indexRotationPeriod() == null) ? 0 : indexRotationPeriod().hashCode());
        hashCode = 31 * hashCode + ((bufferingHints() == null) ? 0 : bufferingHints().hashCode());
        hashCode = 31 * hashCode + ((retryOptions() == null) ? 0 : retryOptions().hashCode());
        hashCode = 31 * hashCode + ((s3Update() == null) ? 0 : s3Update().hashCode());
        hashCode = 31 * hashCode + ((processingConfiguration() == null) ? 0 : processingConfiguration().hashCode());
        hashCode = 31 * hashCode + ((cloudWatchLoggingOptions() == null) ? 0 : cloudWatchLoggingOptions().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchDestinationUpdate)) {
            return false;
        }
        ElasticsearchDestinationUpdate other = (ElasticsearchDestinationUpdate) obj;
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.domainARN() == null ^ this.domainARN() == null) {
            return false;
        }
        if (other.domainARN() != null && !other.domainARN().equals(this.domainARN())) {
            return false;
        }
        if (other.indexName() == null ^ this.indexName() == null) {
            return false;
        }
        if (other.indexName() != null && !other.indexName().equals(this.indexName())) {
            return false;
        }
        if (other.typeName() == null ^ this.typeName() == null) {
            return false;
        }
        if (other.typeName() != null && !other.typeName().equals(this.typeName())) {
            return false;
        }
        if (other.indexRotationPeriod() == null ^ this.indexRotationPeriod() == null) {
            return false;
        }
        if (other.indexRotationPeriod() != null && !other.indexRotationPeriod().equals(this.indexRotationPeriod())) {
            return false;
        }
        if (other.bufferingHints() == null ^ this.bufferingHints() == null) {
            return false;
        }
        if (other.bufferingHints() != null && !other.bufferingHints().equals(this.bufferingHints())) {
            return false;
        }
        if (other.retryOptions() == null ^ this.retryOptions() == null) {
            return false;
        }
        if (other.retryOptions() != null && !other.retryOptions().equals(this.retryOptions())) {
            return false;
        }
        if (other.s3Update() == null ^ this.s3Update() == null) {
            return false;
        }
        if (other.s3Update() != null && !other.s3Update().equals(this.s3Update())) {
            return false;
        }
        if (other.processingConfiguration() == null ^ this.processingConfiguration() == null) {
            return false;
        }
        if (other.processingConfiguration() != null && !other.processingConfiguration().equals(this.processingConfiguration())) {
            return false;
        }
        if (other.cloudWatchLoggingOptions() == null ^ this.cloudWatchLoggingOptions() == null) {
            return false;
        }
        if (other.cloudWatchLoggingOptions() != null && !other.cloudWatchLoggingOptions().equals(this.cloudWatchLoggingOptions())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (roleARN() != null) {
            sb.append("RoleARN: ").append(roleARN()).append(",");
        }
        if (domainARN() != null) {
            sb.append("DomainARN: ").append(domainARN()).append(",");
        }
        if (indexName() != null) {
            sb.append("IndexName: ").append(indexName()).append(",");
        }
        if (typeName() != null) {
            sb.append("TypeName: ").append(typeName()).append(",");
        }
        if (indexRotationPeriod() != null) {
            sb.append("IndexRotationPeriod: ").append(indexRotationPeriod()).append(",");
        }
        if (bufferingHints() != null) {
            sb.append("BufferingHints: ").append(bufferingHints()).append(",");
        }
        if (retryOptions() != null) {
            sb.append("RetryOptions: ").append(retryOptions()).append(",");
        }
        if (s3Update() != null) {
            sb.append("S3Update: ").append(s3Update()).append(",");
        }
        if (processingConfiguration() != null) {
            sb.append("ProcessingConfiguration: ").append(processingConfiguration()).append(",");
        }
        if (cloudWatchLoggingOptions() != null) {
            sb.append("CloudWatchLoggingOptions: ").append(cloudWatchLoggingOptions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ElasticsearchDestinationUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ElasticsearchDestinationUpdate> {
        /**
         * <p>
         * The ARN of the IAM role to be assumed by Firehose for calling the Amazon ES Configuration API and for
         * indexing documents. For more information, see <a
         * href="http://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Amazon S3 Bucket
         * Access</a>.
         * </p>
         * 
         * @param roleARN
         *        The ARN of the IAM role to be assumed by Firehose for calling the Amazon ES Configuration API and for
         *        indexing documents. For more information, see <a
         *        href="http://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Amazon S3
         *        Bucket Access</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The ARN of the Amazon ES domain. The IAM role must have permissions for 
         * <code>DescribeElasticsearchDomain</code>, <code>DescribeElasticsearchDomains</code>, and
         * <code>DescribeElasticsearchDomainConfig</code> after assuming the IAM role specified in <b>RoleARN</b>.
         * </p>
         * 
         * @param domainARN
         *        The ARN of the Amazon ES domain. The IAM role must have permissions for 
         *        <code>DescribeElasticsearchDomain</code>, <code>DescribeElasticsearchDomains</code>, and
         *        <code>DescribeElasticsearchDomainConfig</code> after assuming the IAM role specified in
         *        <b>RoleARN</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainARN(String domainARN);

        /**
         * <p>
         * The Elasticsearch index name.
         * </p>
         * 
         * @param indexName
         *        The Elasticsearch index name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The Elasticsearch type name.
         * </p>
         * 
         * @param typeName
         *        The Elasticsearch type name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The Elasticsearch index rotation period. Index rotation appends a timestamp to IndexName to facilitate the
         * expiration of old data. For more information, see <a
         * href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation for
         * Amazon Elasticsearch Service Destination</a>. Default value is <code>OneDay</code>.
         * </p>
         * 
         * @param indexRotationPeriod
         *        The Elasticsearch index rotation period. Index rotation appends a timestamp to IndexName to facilitate
         *        the expiration of old data. For more information, see <a
         *        href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index
         *        Rotation for Amazon Elasticsearch Service Destination</a>. Default value is <code>OneDay</code>.
         * @see ElasticsearchIndexRotationPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ElasticsearchIndexRotationPeriod
         */
        Builder indexRotationPeriod(String indexRotationPeriod);

        /**
         * <p>
         * The Elasticsearch index rotation period. Index rotation appends a timestamp to IndexName to facilitate the
         * expiration of old data. For more information, see <a
         * href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation for
         * Amazon Elasticsearch Service Destination</a>. Default value is <code>OneDay</code>.
         * </p>
         * 
         * @param indexRotationPeriod
         *        The Elasticsearch index rotation period. Index rotation appends a timestamp to IndexName to facilitate
         *        the expiration of old data. For more information, see <a
         *        href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index
         *        Rotation for Amazon Elasticsearch Service Destination</a>. Default value is <code>OneDay</code>.
         * @see ElasticsearchIndexRotationPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ElasticsearchIndexRotationPeriod
         */
        Builder indexRotationPeriod(ElasticsearchIndexRotationPeriod indexRotationPeriod);

        /**
         * <p>
         * The buffering options. If no value is specified, <b>ElasticsearchBufferingHints</b> object default values are
         * used.
         * </p>
         * 
         * @param bufferingHints
         *        The buffering options. If no value is specified, <b>ElasticsearchBufferingHints</b> object default
         *        values are used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bufferingHints(ElasticsearchBufferingHints bufferingHints);

        /**
         * <p>
         * The retry behavior in the event that Firehose is unable to deliver documents to Amazon ES. Default value is
         * 300 (5 minutes).
         * </p>
         * 
         * @param retryOptions
         *        The retry behavior in the event that Firehose is unable to deliver documents to Amazon ES. Default
         *        value is 300 (5 minutes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryOptions(ElasticsearchRetryOptions retryOptions);

        /**
         * <p>
         * The Amazon S3 destination.
         * </p>
         * 
         * @param s3Update
         *        The Amazon S3 destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Update(S3DestinationUpdate s3Update);

        /**
         * <p>
         * The data processing configuration.
         * </p>
         * 
         * @param processingConfiguration
         *        The data processing configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingConfiguration(ProcessingConfiguration processingConfiguration);

        /**
         * <p>
         * The CloudWatch logging options for your delivery stream.
         * </p>
         * 
         * @param cloudWatchLoggingOptions
         *        The CloudWatch logging options for your delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions);
    }

    private static final class BuilderImpl implements Builder {
        private String roleARN;

        private String domainARN;

        private String indexName;

        private String typeName;

        private String indexRotationPeriod;

        private ElasticsearchBufferingHints bufferingHints;

        private ElasticsearchRetryOptions retryOptions;

        private S3DestinationUpdate s3Update;

        private ProcessingConfiguration processingConfiguration;

        private CloudWatchLoggingOptions cloudWatchLoggingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchDestinationUpdate model) {
            setRoleARN(model.roleARN);
            setDomainARN(model.domainARN);
            setIndexName(model.indexName);
            setTypeName(model.typeName);
            setIndexRotationPeriod(model.indexRotationPeriod);
            setBufferingHints(model.bufferingHints);
            setRetryOptions(model.retryOptions);
            setS3Update(model.s3Update);
            setProcessingConfiguration(model.processingConfiguration);
            setCloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getDomainARN() {
            return domainARN;
        }

        @Override
        public final Builder domainARN(String domainARN) {
            this.domainARN = domainARN;
            return this;
        }

        public final void setDomainARN(String domainARN) {
            this.domainARN = domainARN;
        }

        public final String getIndexName() {
            return indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final String getTypeName() {
            return typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getIndexRotationPeriod() {
            return indexRotationPeriod;
        }

        @Override
        public final Builder indexRotationPeriod(String indexRotationPeriod) {
            this.indexRotationPeriod = indexRotationPeriod;
            return this;
        }

        @Override
        public final Builder indexRotationPeriod(ElasticsearchIndexRotationPeriod indexRotationPeriod) {
            this.indexRotationPeriod(indexRotationPeriod.toString());
            return this;
        }

        public final void setIndexRotationPeriod(String indexRotationPeriod) {
            this.indexRotationPeriod = indexRotationPeriod;
        }

        public final ElasticsearchBufferingHints getBufferingHints() {
            return bufferingHints;
        }

        @Override
        public final Builder bufferingHints(ElasticsearchBufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final void setBufferingHints(ElasticsearchBufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
        }

        public final ElasticsearchRetryOptions getRetryOptions() {
            return retryOptions;
        }

        @Override
        public final Builder retryOptions(ElasticsearchRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final void setRetryOptions(ElasticsearchRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
        }

        public final S3DestinationUpdate getS3Update() {
            return s3Update;
        }

        @Override
        public final Builder s3Update(S3DestinationUpdate s3Update) {
            this.s3Update = s3Update;
            return this;
        }

        public final void setS3Update(S3DestinationUpdate s3Update) {
            this.s3Update = s3Update;
        }

        public final ProcessingConfiguration getProcessingConfiguration() {
            return processingConfiguration;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
        }

        public final CloudWatchLoggingOptions getCloudWatchLoggingOptions() {
            return cloudWatchLoggingOptions;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
        }

        @Override
        public ElasticsearchDestinationUpdate build() {
            return new ElasticsearchDestinationUpdate(this);
        }
    }
}
